/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private String namespaceSeparator = ".";

    public ILeaf getOrCreateLeaf1(Code code, LeafType leafType) {
        if (leafType == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
            if (this.getNamespaceSeparator() == null) {
                return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
            }
            if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
                return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
            }
            return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())), LeafType.CLASS);
        }
        if (this.getNamespaceSeparator() == null) {
            return this.getOrCreateLeaf1Default(code, LeafType.CLASS);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
            return this.getOrCreateLeaf1Default(code, leafType);
        }
        return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())), leafType);
    }

    public ILeaf createLeaf(Code code, Display display, LeafType leafType) {
        if (leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.CLASS && leafType != LeafType.INTERFACE && leafType != LeafType.ENUM && leafType != LeafType.LOLLIPOP) {
            return super.createLeaf(code, display, leafType);
        }
        if (this.getNamespaceSeparator() == null) {
            return super.createLeaf(code, display, leafType);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, display, leafType);
    }

    private ILeaf createEntityWithNamespace(Code code, Display display, LeafType leafType) {
        IGroup iGroup = this.getCurrentGroup();
        String string = code.getNamespace(this.getLeafs(), this.getNamespaceSeparator());
        if (string != null && (EntityUtils.groupRoot(iGroup) || !iGroup.getCode().getCode().equals(string))) {
            iGroup = this.getOrCreateGroupInternal(Code.of(string), Display.getWithNewlines(string), string, GroupType.PACKAGE, this.getRootGroup());
        }
        return this.createLeafInternal(code, display == null ? Display.getWithNewlines(code.getShortName(this.getLeafs(), this.getNamespaceSeparator())) : display, leafType, iGroup);
    }

    public final boolean leafExist(Code code) {
        if (this.getNamespaceSeparator() == null) {
            return super.leafExist(code);
        }
        return super.leafExist(code.getFullyQualifiedCode(this.getCurrentGroup(), this.getNamespaceSeparator()));
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    private String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(String string) {
        this.namespaceSeparator = string;
    }
}

