/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkClass(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, CommandLinkClass.getRegexConcat(abstractClassOrObjectDiagram.getUmlDiagramType()));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)\\s+)?"), new RegexOr(new RegexLeaf("ENT1", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE1", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexLeaf("FIRST_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "( +o|[\\[<*+^]|[<\\[]\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "(o +|[\\]>*+^]|\\|[>\\]])?")), new RegexLeaf("\\s*"), new RegexLeaf("SECOND_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("ENT2", "(?:" + CommandLinkClass.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE2", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexLeaf("LABEL_LINK", "(?::\\s*(.+))?"), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|abstract\\s+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        Object object;
        Object object2;
        Object object3;
        Code code = Code.of(regexResult.get("ENT1", 1));
        Code code2 = Code.of(regexResult.get("ENT2", 1));
        if (code == null) {
            return this.executeArgSpecial1(regexResult);
        }
        if (code2 == null) {
            return this.executeArgSpecial2(regexResult);
        }
        code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
        code2 = code2.eventuallyRemoveStartingAndEndingDoubleQuote();
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(code) && ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(code2)) {
            return this.executePackageLink(regexResult);
        }
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(code) || ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(code2)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        ILeaf iLeaf = (ILeaf)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code, null);
        ILeaf iLeaf2 = (ILeaf)((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code2, null);
        if (regexResult.get("ENT1", 0) != null && (object3 = LeafType.getLeafType(regexResult.get("ENT1", 0))) != LeafType.OBJECT) {
            iLeaf.muteToType((LeafType)((Object)object3));
        }
        if (regexResult.get("ENT2", 0) != null && (object3 = LeafType.getLeafType(regexResult.get("ENT2", 0))) != LeafType.OBJECT) {
            iLeaf2.muteToType((LeafType)((Object)object3));
        }
        if (regexResult.get("ENT1", 2) != null) {
            iLeaf.setStereotype(new Stereotype(regexResult.get("ENT1", 2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if (regexResult.get("ENT2", 2) != null) {
            iLeaf2.setStereotype(new Stereotype(regexResult.get("ENT2", 2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        object3 = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        String string = regexResult.get("FIRST_LABEL", 0);
        String string2 = regexResult.get("SECOND_LABEL", 0);
        String string3 = null;
        if (regexResult.get("LABEL_LINK", 0) != null) {
            string3 = regexResult.get("LABEL_LINK", 0);
            if (string == null && string2 == null) {
                object2 = Pattern.compile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
                object = ((Pattern)object2).matcher(string3);
                if (((Matcher)object).matches()) {
                    string = ((Matcher)object).group(1);
                    string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(((Matcher)object).group(2).trim()).trim();
                    string2 = ((Matcher)object).group(3);
                } else {
                    Pattern pattern = Pattern.compile("^\"([^\"]+)\"([^\"]+)$");
                    Matcher matcher = pattern.matcher(string3);
                    if (matcher.matches()) {
                        string = matcher.group(1);
                        string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(2).trim()).trim();
                        string2 = null;
                    } else {
                        Pattern pattern2 = Pattern.compile("^([^\"]+)\"([^\"]+)\"$");
                        Matcher matcher2 = pattern2.matcher(string3);
                        if (matcher2.matches()) {
                            string = null;
                            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher2.group(1).trim()).trim();
                            string2 = matcher2.group(2);
                        }
                    }
                }
            }
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3);
        }
        object2 = LinkArrow.NONE;
        if ("<".equals(string3)) {
            object2 = LinkArrow.BACKWARD;
            string3 = null;
        } else if (">".equals(string3)) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string3 = null;
        } else if (string3 != null && string3.startsWith("< ")) {
            object2 = LinkArrow.BACKWARD;
            string3 = string3.substring(2).trim();
        } else if (string3 != null && string3.startsWith("> ")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string3 = string3.substring(2).trim();
        } else if (string3 != null && string3.endsWith(" >")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string3 = string3.substring(0, string3.length() - 2).trim();
        } else if (string3 != null && string3.endsWith(" <")) {
            object2 = LinkArrow.BACKWARD;
            string3 = string3.substring(0, string3.length() - 2).trim();
        }
        object = new Link(iLeaf, iLeaf2, (LinkType)object3, Display.getWithNewlines(string3), n, string, string2, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            object = ((Link)object).getInv();
        }
        ((Link)object).setLinkArrow((LinkArrow)((Object)object2));
        CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), (Link)object);
        this.addLink((Link)object, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string != null) {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(RegexResult regexResult) {
        String string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 1));
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 1));
        IGroup iGroup = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(Code.of(string));
        IGroup iGroup2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(Code.of(string2));
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        Display display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0));
        String string3 = regexResult.get("FIRST_LABEL", 0);
        String string4 = regexResult.get("SECOND_LABEL", 0);
        Link link = new Link(iGroup, iGroup2, linkType, display, n, string3, string4, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(RegexResult regexResult) {
        Code code = Code.of(regexResult.get("COUPLE1", 0));
        Code code2 = Code.of(regexResult.get("COUPLE1", 1));
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 1)));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code3, null);
        LinkType linkType = this.getLinkType(regexResult);
        Display display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0));
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(1, code, code2, iEntity, linkType, display);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(RegexResult regexResult) {
        Code code = Code.of(regexResult.get("COUPLE2", 0));
        Code code2 = Code.of(regexResult.get("COUPLE2", 1));
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 1)));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code3, null);
        LinkType linkType = this.getLinkType(regexResult);
        Display display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0));
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(2, code, code2, iEntity, linkType, display);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(string = string.trim())) {
            return LinkDecor.EXTENDS;
        }
        if ("<".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(string = string.trim())) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult regexResult) {
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        LinkType linkType = new LinkType(linkDecor2, linkDecor);
        if (regexResult.get("ARROW_BODY1", 0).contains(".") || regexResult.get("ARROW_BODY2", 0).contains(".")) {
            linkType = linkType.getDashed();
        }
        return linkType;
    }

    private int getQueueLength(RegexResult regexResult) {
        String string = this.getFullArrow(regexResult);
        string = string.replaceAll("[^-.=]", "");
        return string.length();
    }

    private Direction getDirection(RegexResult regexResult) {
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        String string = this.getFullArrow(regexResult);
        if ((string = string.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            string = string.substring(1);
        }
        if (string.endsWith("o")) {
            string = string.substring(0, string.length() - 1);
        }
        Direction direction = StringUtils.getQueueDirection(string);
        if (this.isInversed(linkDecor, linkDecor2) && string.matches(".*\\w.*")) {
            direction = direction.getInv();
        }
        return direction;
    }

    private String getFullArrow(RegexResult regexResult) {
        return CommandLinkClass.notNull(regexResult.get("ARROW_HEAD1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY2", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_HEAD2", 0));
    }

    public static String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static void applyStyle(String string, Link link) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed")) {
                link.goDashed();
                continue;
            }
            if (string2.equalsIgnoreCase("bold")) {
                link.goBold();
                continue;
            }
            if (string2.equalsIgnoreCase("dotted")) {
                link.goDotted();
                continue;
            }
            if (string2.equalsIgnoreCase("hidden")) {
                link.goHidden();
                continue;
            }
            link.setSpecificColor(string2);
        }
    }

    private boolean isInversed(LinkDecor linkDecor, LinkDecor linkDecor2) {
        if (linkDecor == LinkDecor.ARROW && linkDecor2 != LinkDecor.ARROW) {
            return true;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return true;
        }
        return linkDecor2 == LinkDecor.PLUS;
    }
}

