/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines2<S extends PSystem>
implements Command {
    private final S system;
    private final RegexConcat starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines2(S s, RegexConcat regexConcat, MultilinesStrategy multilinesStrategy) {
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.strategy = multilinesStrategy;
        this.system = s;
        this.starting = regexConcat;
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        list = this.strategy.filter(list);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        boolean bl = this.starting.match(list.get(0).trim());
        if (!bl) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher matcher = Pattern.compile(this.getPatternEnd()).matcher(list.get(list.size() - 1).trim());
        if (!matcher.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        return this.executeNow(this.strategy.filter(list));
    }

    public abstract CommandExecutionResult executeNow(List<String> var1);

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected S getSystem() {
        return this.system;
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }

    @Override
    public boolean isDeprecated(List<String> list) {
        return false;
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }
}

