/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryNoteOnEntityCommand(IRegex iRegex) {
        this.partialPattern = iRegex;
    }

    private RegexConcat getRegexConcatSingleLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("\\s+of\\s+"), iRegex), new RegexLeaf("")), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("\\s+of\\s+"), iRegex), new RegexLeaf("")), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*\\{?"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(final AbstractEntityDiagram abstractEntityDiagram) {
        return new SingleLineCommand2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(RegexResult regexResult) {
                String string = regexResult.get("NOTE", 0);
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, null, StringUtils.getWithNewlines2(string));
            }
        };
    }

    @Override
    public Command createMultiLine(final AbstractEntityDiagram abstractEntityDiagram) {
        return new CommandMultilines2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatMultiLine(this.partialPattern), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^(end ?note|\\})$";
            }

            @Override
            public CommandExecutionResult executeNow(List<String> list) {
                StringUtils.trim(list, false);
                RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                Url url = null;
                if (list2.size() > 0) {
                    UrlBuilder urlBuilder = new UrlBuilder(((AbstractEntityDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
                    url = urlBuilder.getUrl(list2.get(0));
                }
                if (url != null) {
                    list2 = list2.subList(1, list2.size());
                }
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, url, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult regexResult, AbstractEntityDiagram abstractEntityDiagram, Url url, List<? extends CharSequence> list) {
        Link link;
        IEntity iEntity;
        String string = regexResult.get("POSITION", 0);
        Code code = Code.of(regexResult.get("ENTITY", 0));
        if (code == null) {
            iEntity = abstractEntityDiagram.getLastEntity();
            if (iEntity == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            iEntity = abstractEntityDiagram.getOrCreateLeaf1(code, null);
        }
        ILeaf iLeaf = abstractEntityDiagram.createLeaf(UniqueSequence.getCode("GMN"), new Display(list), LeafType.NOTE);
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        if (url != null) {
            iLeaf.addUrl(url);
        }
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(abstractEntityDiagram.getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, iLeaf, linkType, null, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(iLeaf, iEntity, linkType, null, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, iLeaf, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(iLeaf, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        abstractEntityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

