/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMakerResult;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramPngMaker3;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final EntityFactory entityFactory = new EntityFactory();
    private IGroup currentGroup = this.entityFactory.getRootGroup();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private boolean visibilityModifierPresent;
    private String warningOrError;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();

    public abstract IEntity getOrCreateLeaf1(Code var1, LeafType var2);

    public boolean hasUrl() {
        for (ILeaf hideable : this.getLeafs().values()) {
            if (hideable.getUrls().size() <= 0) continue;
            return true;
        }
        for (Link link : this.getLinks()) {
            if (link.getUrl() == null) continue;
            return true;
        }
        return false;
    }

    protected final ILeaf getOrCreateLeaf1Default(Code code, LeafType leafType) {
        if (leafType == null) {
            throw new IllegalArgumentException();
        }
        ILeaf iLeaf = this.getLeafs().get(code);
        if (iLeaf == null) {
            iLeaf = this.createLeafInternal(code, Display.getWithNewlines(code), leafType, this.getCurrentGroup());
        }
        return iLeaf;
    }

    public ILeaf createLeaf(Code code, Display display, LeafType leafType) {
        if (this.getLeafs().containsKey(code)) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createLeafInternal(code, display, leafType, this.getCurrentGroup());
    }

    protected final ILeaf createLeafInternal(Code code, Display display, LeafType leafType, IGroup iGroup) {
        if (display == null) {
            display = Display.getWithNewlines(code);
        }
        ILeaf iLeaf = this.entityFactory.createLeaf(code, display, leafType, iGroup, this.getHides());
        this.entityFactory.addLeaf(iLeaf);
        return iLeaf;
    }

    public boolean leafExist(Code code) {
        return this.getLeafs().containsKey(code);
    }

    @Override
    public final Collection<IGroup> getChildrenGroups(IGroup iGroup) {
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup2 : this.getGroups(false)) {
            if (iGroup2.getParentContainer() != iGroup) continue;
            arrayList.add(iGroup2);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public final IGroup getOrCreateGroup(Code code, Display display, String string, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2;
        this.currentGroup = iGroup2 = this.getOrCreateGroupInternal(code, display, string, groupType, iGroup);
        return iGroup2;
    }

    protected final IGroup getOrCreateGroupInternal(Code code, Display display, String string, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2 = this.entityFactory.getGroups().get(code);
        if (iGroup2 != null) {
            return iGroup2;
        }
        if (this.entityFactory.getLeafs().containsKey(code)) {
            iGroup2 = this.entityFactory.muteToGroup(code, string, groupType, iGroup);
            iGroup2.setDisplay(display);
        } else {
            iGroup2 = this.entityFactory.createGroup(code, display, string, groupType, iGroup, this.getHides());
        }
        this.entityFactory.addGroup(iGroup2);
        return iGroup2;
    }

    public final IGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public final IGroup getGroup(Code code) {
        IGroup iGroup = this.entityFactory.getGroups().get(code);
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        return iGroup;
    }

    public void endGroup() {
        if (EntityUtils.groupRoot(this.currentGroup)) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = this.currentGroup.getParentContainer();
    }

    public final boolean isGroup(Code code) {
        return this.entityFactory.getGroups().containsKey(code);
    }

    public final Collection<IGroup> getGroups(boolean bl) {
        if (!bl) {
            return this.entityFactory.getGroups().values();
        }
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        arrayList.add(this.getRootGroup());
        arrayList.addAll(this.entityFactory.getGroups().values());
        return Collections.unmodifiableCollection(arrayList);
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public final Map<Code, ILeaf> getLeafs() {
        return this.entityFactory.getLeafs();
    }

    public final void addLink(Link link) {
        this.entityFactory.addLink(link);
    }

    protected final void removeLink(Link link) {
        this.entityFactory.removeLink(link);
    }

    public final List<Link> getLinks() {
        return this.entityFactory.getLinks();
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int n) {
        this.horizontalPages = n;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int n) {
        this.verticalPages = n;
    }

    public final List<File> createPng2(File file) throws IOException, InterruptedException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        return cucaDiagramPngMaker3.createPng(file);
    }

    public final void createPng2(OutputStream outputStream) throws IOException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        cucaDiagramPngMaker3.createPng(outputStream);
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getDotStrings()) {
            if (!string.startsWith("nodesep") && !string.startsWith("ranksep")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void createFilesXmi(OutputStream outputStream, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker cucaDiagramXmiMaker = new CucaDiagramXmiMaker(this, fileFormat);
        cucaDiagramXmiMaker.createFiles(outputStream);
    }

    private List<File> createFilesHtml(File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        File file2 = new File(file.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(this, file2);
        return cucaDiagramHtmlMaker.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> exportDiagrams(File file, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
            return this.createFilesHtml(file);
        }
        CMapData cMapData = new CMapData();
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportDiagram(outputStream, cMapData, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        List<File> list = Arrays.asList(file);
        if (this.hasUrl() && cMapData.containsData()) {
            this.exportCmap(file, cMapData);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(file, this.getHorizontalPages(), this.getVerticalPages(), this.getMetadata(), this.getDpi(fileFormatOption)).getFiles();
        }
        return list;
    }

    @Override
    protected final UmlDiagramInfo exportDiagramInternal(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption, List<BufferedImage> list) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(outputStream, n, fileFormat);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(new PrintStream(outputStream));
            }
            return new UmlDiagramInfo();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(outputStream, fileFormat);
            return new UmlDiagramInfo();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        CucaDiagramFileMakerSvek cucaDiagramFileMakerSvek = new CucaDiagramFileMakerSvek(this, list);
        CucaDiagramFileMakerResult cucaDiagramFileMakerResult = cucaDiagramFileMakerSvek.createFile(outputStream, this.getDotStrings(), fileFormatOption);
        if (cucaDiagramFileMakerResult != null && cMapData != null && cucaDiagramFileMakerResult.getCmapResult() != null) {
            cMapData.copy(cucaDiagramFileMakerResult.getCmapResult());
        }
        if (cucaDiagramFileMakerResult != null) {
            this.warningOrError = cucaDiagramFileMakerResult.getWarningOrError();
        }
        return cucaDiagramFileMakerResult == null ? new UmlDiagramInfo() : new UmlDiagramInfo(cucaDiagramFileMakerResult.getWidth());
    }

    @Override
    public String getWarningOrError() {
        String string = super.getWarningOrError();
        if (this.warningOrError == null) {
            return string;
        }
        if (string == null) {
            return this.warningOrError;
        }
        return string + "\n" + this.warningOrError;
    }

    private void createFilesTxt(OutputStream outputStream, int n, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker cucaDiagramTxtMaker = new CucaDiagramTxtMaker(this, fileFormat);
        cucaDiagramTxtMaker.createFiles(outputStream, n);
    }

    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    public boolean isAutarkic(IGroup iGroup) {
        if (iGroup.zgetGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (iGroup.zgetGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (iGroup.zgetGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(iGroup).size() > 0) {
            return false;
        }
        for (Link hideable : this.getLinks()) {
            if (EntityUtils.isPureInnerLink3(iGroup, hideable)) continue;
            return false;
        }
        for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
            if (iLeaf.getEntityPosition() == EntityPosition.NORMAL) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String string) {
        return string.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String string;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("labeldistance"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabeldistance"))) {
            return string;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String string;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("labelangle"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabelangle"))) {
            return string;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(IGroup iGroup) {
        for (IGroup iGroup2 : this.getGroups(false)) {
            if (iGroup2 == iGroup || iGroup2.getParentContainer() != iGroup) continue;
            return false;
        }
        return iGroup.zsize() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean bl) {
        this.visibilityModifierPresent = bl;
    }

    @Override
    public final boolean showPortion(EntityPortion entityPortion, ILeaf iLeaf) {
        boolean bl = true;
        for (HideOrShow hideOrShow : this.hideOrShows) {
            if (hideOrShow.portion != entityPortion || !hideOrShow.gender.contains(iLeaf)) continue;
            bl = hideOrShow.show;
        }
        return bl;
    }

    public final void hideOrShow(EntityGender entityGender, Set<EntityPortion> set, boolean bl) {
        for (EntityPortion entityPortion : set) {
            this.hideOrShows.add(new HideOrShow(entityGender, entityPortion, bl));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> set, boolean bl) {
        if (bl) {
            this.hides.removeAll(set);
        } else {
            this.hides.addAll(set);
        }
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    public final boolean isStandalone(IEntity iEntity) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != iEntity && link.getEntity2() != iEntity) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> list = this.getLinks();
        for (int i = list.size() - 1; i >= 0; --i) {
            Link link = list.get(i);
            if (link.getEntity1().getEntityType() == LeafType.NOTE || link.getEntity2().getEntityType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final ILeaf getLastEntity() {
        Iterator<ILeaf> iterator = this.getLeafs().values().iterator();
        while (iterator.hasNext()) {
            ILeaf iLeaf = iterator.next();
            if (iterator.hasNext()) continue;
            return iLeaf;
        }
        return null;
    }

    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void applySingleStrategy() {
        for (IGroup iGroup : this.getGroups(true)) {
            ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
            SingleStrategy singleStrategy = iGroup.getSingleStrategy();
            for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
                if (!this.isStandalone(iLeaf)) continue;
                arrayList.add(iLeaf);
            }
            if (arrayList.size() < 3) continue;
            for (Link link : singleStrategy.generateLinks(arrayList)) {
                this.addLink(link);
            }
        }
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender entityGender, EntityPortion entityPortion, boolean bl) {
            this.gender = entityGender;
            this.portion = entityPortion;
            this.show = bl;
        }
    }
}

