/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.font;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemListFonts
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();

    public PSystemListFonts(String string) {
        String[] stringArray;
        this.strings.add("   <b><size:16>Fonts available:");
        this.strings.add(" ");
        for (String string2 : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.strings.add(string2 + " : <font:" + string2 + ">" + string);
        }
    }

    public void exportDiagram(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption) throws IOException {
        this.getGraphicStrings().writeImage(outputStream, fileFormatOption);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(this.strings, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, false);
        return graphicStrings;
    }

    public String getDescription() {
        return "(List fonts)";
    }
}

