/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.golem;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile
implements TextBlock {
    private static double SIZE = 40.0;
    private final int num;
    private final UFont numberFont = new UFont("Monospaced", 0, 11);
    private final FontConfiguration fc = new FontConfiguration(this.numberFont, HtmlColorUtils.BLACK);
    private final Map<TileGeometry, TileArea> geometries;

    Tile(int n) {
        this.num = n;
        EnumMap<TileGeometry, TileArea> enumMap = new EnumMap<TileGeometry, TileArea>(TileGeometry.class);
        for (TileGeometry tileGeometry : TileGeometry.values()) {
            enumMap.put(tileGeometry, new TileArea(this, tileGeometry));
        }
        this.geometries = Collections.unmodifiableMap(enumMap);
    }

    public TileArea getArea(TileGeometry tileGeometry) {
        return this.geometries.get((Object)tileGeometry);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
        TextBlock textBlock = TextBlockUtils.create(Display.asList("" + this.num), this.fc, HorizontalAlignement.LEFT, new SpriteContainerEmpty());
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D2 = this.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D2.getWidth() - dimension2D.getWidth();
        double d4 = dimension2D2.getHeight() - dimension2D.getHeight();
        double d5 = Math.max(dimension2D.getWidth(), dimension2D.getHeight());
        double d6 = dimension2D2.getWidth() - d5;
        double d7 = dimension2D2.getHeight() - d5;
        textBlock.drawU(uGraphic, d + d3 / 2.0, d2 + d4 / 2.0);
        uGraphic.draw(d, d2, new URectangle(SIZE, SIZE));
        uGraphic.draw(d + d6 / 2.0, d2 + d7 / 2.0, new UEllipse(d5, d5));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(SIZE, SIZE);
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

