/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class SymbolContext {
    private final HtmlColor backColor;
    private final HtmlColor foreColor;
    private final UStroke stroke;
    private final boolean shadowing;

    private SymbolContext(HtmlColor htmlColor, HtmlColor htmlColor2, UStroke uStroke, boolean bl) {
        this.backColor = htmlColor;
        this.foreColor = htmlColor2;
        this.stroke = uStroke;
        this.shadowing = bl;
        if (htmlColor instanceof HtmlColorTransparent) {
            throw new UnsupportedOperationException();
        }
    }

    public void apply(UGraphic uGraphic) {
        uGraphic.getParam().setColor(this.foreColor);
        uGraphic.getParam().setBackcolor(this.backColor);
        uGraphic.getParam().setStroke(this.stroke);
    }

    public SymbolContext(HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(htmlColor, htmlColor2, new UStroke(), false);
    }

    public SymbolContext withShadow(boolean bl) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, bl);
    }

    public SymbolContext withStroke(UStroke uStroke) {
        return new SymbolContext(this.backColor, this.foreColor, uStroke, this.shadowing);
    }

    public HtmlColor getBackColor() {
        return this.backColor;
    }

    public HtmlColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.shadowing;
    }
}

