/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockArrow
implements TextBlock {
    private final double size;
    private final Direction arrow;
    private final HtmlColor color;

    public TextBlockArrow(Direction direction, FontConfiguration fontConfiguration) {
        if (direction == null) {
            throw new IllegalArgumentException();
        }
        this.arrow = direction;
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(this.color);
        uGraphic.getParam().setColor(this.color);
        int n = (int)(this.size * 0.8 - 3.0);
        if (n % 2 == 1) {
            --n;
        }
        UPolygon uPolygon = this.getTriangle(n);
        if (this.arrow == Direction.RIGHT || this.arrow == Direction.LEFT) {
            uGraphic.draw(d + 2.0, d2 + (this.size - (double)n) - 2.0, uPolygon);
        } else {
            uGraphic.draw(d + 2.0, d2 + (this.size - (double)n) - 2.0, uPolygon);
        }
    }

    private UPolygon getTriangle(int n) {
        UPolygon uPolygon = new UPolygon();
        if (this.arrow == Direction.RIGHT) {
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(n, n / 2);
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(0.0, 0.0);
        } else if (this.arrow == Direction.LEFT) {
            uPolygon.addPoint(n, 0.0);
            uPolygon.addPoint(0.0, n / 2);
            uPolygon.addPoint(n, n);
            uPolygon.addPoint(n, 0.0);
        } else if (this.arrow == Direction.UP) {
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(n / 2, 0.0);
            uPolygon.addPoint(n, n);
            uPolygon.addPoint(0.0, n);
        } else if (this.arrow == Direction.DOWN) {
            uPolygon.addPoint(0.0, 0.0);
            uPolygon.addPoint(n / 2, n);
            uPolygon.addPoint(n, 0.0);
            uPolygon.addPoint(0.0, 0.0);
        } else {
            throw new IllegalStateException();
        }
        return uPolygon;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.size, this.size);
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

