/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class TextBlockSpotted
extends TextBlockSimple {
    private final CircledCharacter circledCharacter;

    public TextBlockSpotted(CircledCharacter circledCharacter, Display display, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        super(display, fontConfiguration, horizontalAlignement, spriteContainer);
        this.circledCharacter = circledCharacter;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getCircledCharacterWithAndMargin(stringBounder);
        double d2 = this.circledCharacter.getPreferredHeight(stringBounder);
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getCircledCharacterWithAndMargin(StringBounder stringBounder) {
        return this.circledCharacter.getPreferredWidth(stringBounder) + 6.0;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.circledCharacter.drawU(uGraphic, d, d2);
        uGraphic.setTranslate(d3, d4);
        double d5 = this.getCircledCharacterWithAndMargin(stringBounder);
        uGraphic.translate(d5, 0.0);
        super.drawU(uGraphic, d, d2);
        uGraphic.setTranslate(d3, d4);
    }
}

