/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockVertical2
implements TextBlock {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final HorizontalAlignement horizontalAlignement;

    public TextBlockVertical2(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignement horizontalAlignement) {
        this.blocks.add(textBlock);
        this.blocks.add(textBlock2);
        this.horizontalAlignement = horizontalAlignement;
    }

    public TextBlockVertical2(List<TextBlock> list, HorizontalAlignement horizontalAlignement) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(list);
        this.horizontalAlignement = horizontalAlignement;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dimension2D = Dimension2DDouble.mergeTB(dimension2D, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        for (TextBlock textBlock : this.blocks) {
            Dimension2D dimension2D2 = textBlock.calculateDimension(uGraphic.getStringBounder());
            if (this.horizontalAlignement == HorizontalAlignement.LEFT) {
                textBlock.drawU(uGraphic, d, d2);
                uGraphic.getParam().setColor(htmlColor);
            } else if (this.horizontalAlignement == HorizontalAlignement.CENTER) {
                double d3 = (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0;
                textBlock.drawU(uGraphic, d + d3, d2);
                uGraphic.getParam().setColor(htmlColor);
            } else {
                throw new UnsupportedOperationException();
            }
            d2 += dimension2D2.getHeight();
        }
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

