/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class TextBlockWithNumber
extends TextBlockSimple {
    private final TextBlock numText;

    public TextBlockWithNumber(String string, Display display, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        super(display, fontConfiguration, horizontalAlignement, spriteContainer);
        this.numText = TextBlockUtils.create(Display.asList(string), fontConfiguration, HorizontalAlignement.LEFT, spriteContainer);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getNumberWithAndMargin(stringBounder);
        double d2 = this.numText.calculateDimension(stringBounder).getHeight();
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getNumberWithAndMargin(StringBounder stringBounder) {
        double d = this.numText.calculateDimension(stringBounder).getWidth();
        return d + 4.0;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d3 = this.numText.calculateDimension(stringBounder).getHeight();
        double d4 = this.calculateDimension(stringBounder).getHeight() - d3;
        this.numText.drawU(uGraphic, d, d2 + d4 / 2.0);
        super.drawU(uGraphic, d + this.getNumberWithAndMargin(stringBounder), d2);
    }
}

