/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbolActor;
import net.sourceforge.plantuml.graphic.USymbolArtifact;
import net.sourceforge.plantuml.graphic.USymbolBoundary;
import net.sourceforge.plantuml.graphic.USymbolCloud;
import net.sourceforge.plantuml.graphic.USymbolComponent1;
import net.sourceforge.plantuml.graphic.USymbolComponent2;
import net.sourceforge.plantuml.graphic.USymbolControl;
import net.sourceforge.plantuml.graphic.USymbolDatabase;
import net.sourceforge.plantuml.graphic.USymbolEntityDomain;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.USymbolFrame;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.graphic.USymbolNode;
import net.sourceforge.plantuml.graphic.USymbolRect;
import net.sourceforge.plantuml.graphic.USymbolStorage;

public abstract class USymbol {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbol.record("STORAGE", new USymbolStorage());
    public static final USymbol DATABASE = USymbol.record("DATABASE", new USymbolDatabase());
    public static final USymbol CLOUD = USymbol.record("CLOUD", new USymbolCloud());
    public static final USymbol FRAME = USymbol.record("FRAME", new USymbolFrame());
    public static final USymbol NODE = USymbol.record("NODE", new USymbolNode());
    public static final USymbol ARTIFACT = USymbol.record("ARTIFACT", new USymbolArtifact());
    public static final USymbol PACKAGE = USymbol.record("PACKAGE", new USymbolFolder());
    public static final USymbol FOLDER = USymbol.record("FOLDER", new USymbolFolder());
    public static final USymbol RECT = USymbol.record("RECT", new USymbolRect());
    public static final USymbol RECTANGLE = USymbol.record("RECTANGLE", new USymbolRect());
    public static final USymbol ACTOR = USymbol.record("ACTOR", new USymbolActor());
    public static final USymbol COMPONENT1 = USymbol.record("COMPONENT1", new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbol.record("COMPONENT2", new USymbolComponent2());
    public static final USymbol BOUNDARY = USymbol.record("BOUNDARY", new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbol.record("ENTITY_DOMAIN", new USymbolEntityDomain(2.0));
    public static final USymbol CONTROL = USymbol.record("CONTROL", new USymbolControl(2.0));
    public static final USymbol INTERFACE = USymbol.record("INTERFACE", new USymbolInterface());

    public static USymbol getFromString(String string) {
        USymbol uSymbol = all.get(string.toUpperCase());
        if (uSymbol == null) {
            throw new IllegalArgumentException("s=" + string);
        }
        return uSymbol;
    }

    private static USymbol record(String string, USymbol uSymbol) {
        all.put(string.toUpperCase(), uSymbol);
        return uSymbol;
    }

    public abstract TextBlock asSmall(TextBlock var1, TextBlock var2, SymbolContext var3);

    public abstract TextBlock asBig(TextBlock var1, TextBlock var2, double var3, double var5, SymbolContext var7);

    public boolean manageHorizontalLine() {
        return false;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        Margin(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.x2 = d2;
            this.y1 = d3;
            this.y2 = d4;
        }

        double getWidth() {
            return this.x1 + this.x2;
        }

        double getHeight() {
            return this.y1 + this.y2;
        }

        public Dimension2D addDimension(Dimension2D dimension2D) {
            return new Dimension2DDouble(dimension2D.getWidth() + this.x1 + this.x2, dimension2D.getHeight() + this.y1 + this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }
    }
}

