/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;

class USymbolFrame
extends USymbol {
    USymbolFrame() {
    }

    private void drawFrame(UGraphic uGraphic, double d, double d2, double d3, double d4, Dimension2D dimension2D, boolean bl) {
        int n;
        double d5;
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uRectangle);
        if (dimension2D.getWidth() == 0.0) {
            d5 = d3 / 3.0;
            n = 7;
        } else {
            d5 = dimension2D.getWidth() + 10.0;
            n = 10;
        }
        double d6 = this.getYpos(dimension2D);
        UPath uPath = new UPath();
        uPath.moveTo(d5, 1.0);
        uPath.lineTo(d5, d6 - (double)n);
        uPath.lineTo(d5 - (double)n, d6);
        uPath.lineTo(0.0, d6);
        uGraphic.draw(d, d2, uPath);
    }

    private double getYpos(Dimension2D dimension2D) {
        if (dimension2D.getWidth() == 0.0) {
            return 12.0;
        }
        return dimension2D.getHeight() + 3.0;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolFrame.this.drawFrame(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight(), new Dimension2DDouble(0.0, 0.0), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolFrame.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignement.CENTER);
                textBlock3.drawU(uGraphic, d + margin.getX1(), d2 + margin.getY1());
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolFrame.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d4, double d22) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                symbolContext.apply(uGraphic);
                Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
                USymbolFrame.this.drawFrame(uGraphic, d4, d22, dimension2D.getWidth(), dimension2D.getHeight(), dimension2D2, symbolContext.isShadowing());
                textBlock.drawU(uGraphic, d4 + 3.0, d22 + 1.0);
                Dimension2D dimension2D3 = textBlock2.calculateDimension(stringBounder);
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic, d4 + 4.0 + d3, d22 + 2.0 + USymbolFrame.this.getYpos(dimension2D2));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }
}

