/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jcckit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckit;

public class PSystemJcckitFactory
implements PSystemBasicFactory {
    private StringBuilder data;
    private boolean first;
    private int width;
    private int height;
    private final DiagramType diagramType;

    public PSystemJcckitFactory(DiagramType diagramType) {
        this.diagramType = diagramType;
    }

    public void init(String string) {
        this.data = null;
        this.width = 640;
        this.height = 400;
        if (this.diagramType == DiagramType.UML) {
            this.first = true;
        } else if (this.diagramType == DiagramType.JCCKIT) {
            this.first = false;
            this.extractDimension(string);
            this.data = new StringBuilder();
        } else {
            throw new IllegalStateException(this.diagramType.name());
        }
    }

    private void extractDimension(String string) {
        Pattern pattern = Pattern.compile("\\((\\d+),(\\d+)\\)");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }
    }

    String getDimension() {
        return "" + this.width + "-" + this.height;
    }

    public PSystemJcckit getSystem() {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(this.data.toString()));
        }
        catch (IOException iOException) {
            Log.error("Error " + iOException);
            iOException.printStackTrace();
            return null;
        }
        return new PSystemJcckit(properties, this.width, this.height);
    }

    public boolean executeLine(String string) {
        if (this.first && string.startsWith("jcckit")) {
            this.data = new StringBuilder();
            this.extractDimension(string);
            return true;
        }
        this.first = false;
        if (this.data == null) {
            return false;
        }
        this.data.append(string.trim());
        this.data.append("\n");
        return true;
    }

    public DiagramType getDiagramType() {
        return this.diagramType;
    }
}

