/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PngTitler {
    private final HtmlColor textColor;
    private final Display text;
    private final int fontSize;
    private final String fontFamily;
    private final HorizontalAlignement horizontalAlignement;

    public PngTitler(HtmlColor htmlColor, Display display, int n, String string, HorizontalAlignement horizontalAlignement) {
        this.textColor = htmlColor;
        this.text = display;
        this.fontSize = n;
        this.fontFamily = string;
        this.horizontalAlignement = horizontalAlignement;
    }

    public Dimension2D getTextDimension(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return null;
        }
        return textBlock.calculateDimension(stringBounder);
    }

    public TextBlock getTextBlock() {
        if (this.text == null || this.text.size() == 0) {
            return null;
        }
        UFont uFont = new UFont(this.fontFamily, 0, this.fontSize);
        return TextBlockUtils.create(this.text, new FontConfiguration(uFont, this.textColor), this.horizontalAlignement, new SpriteContainerEmpty());
    }

    public double getOffsetX(double d, StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return 0.0;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        if (d >= dimension2D.getWidth()) {
            return 0.0;
        }
        return (dimension2D.getWidth() - d) / 2.0;
    }

    public double getOffsetY(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        if (textBlock == null) {
            return 0.0;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        double d = dimension2D.getHeight();
        return d;
    }
}

