/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(File file, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.raw = StartDiagramExtractReader.getReadLine(file);
        String string = null;
        while ((string = this.raw.readLine()) != null) {
            if (!StartUtils.isArobaseStartDiagram(string)) continue;
            if (n == 0) {
                return;
            }
            --n;
        }
        this.finished = true;
    }

    private static ReadLine getReadLine(File file) throws FileNotFoundException {
        return new UncommentReadLine(new ReadLineReader(new FileReader(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsStartDiagram(File file) throws IOException {
        ReadLine readLine = null;
        try {
            readLine = StartDiagramExtractReader.getReadLine(file);
            String string = null;
            while ((string = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(string)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (readLine != null) {
                readLine.close();
            }
        }
        return false;
    }

    public String readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        String string = this.raw.readLine();
        if (string != null && StartUtils.isArobaseEndDiagram(string)) {
            this.finished = true;
            return null;
        }
        return string;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

