/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.project2.GanttDiagram2;
import net.sourceforge.plantuml.project2.Project2;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class PSystemProject2
extends AbstractPSystem {
    private final Project2 project = new Project2();
    private final Color background = Color.WHITE;
    private final ColorMapper colorMapper = new ColorMapperIdentity();

    public int getNbImages() {
        return 1;
    }

    public String getDescription() {
        return "(Project)";
    }

    public void exportDiagram(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption) throws IOException {
        GanttDiagram2 ganttDiagram2 = new GanttDiagram2(this.project);
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = this.createImage(ganttDiagram2);
            PngIO.write((RenderedImage)bufferedImage, outputStream, this.getMetadata(), 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, StringUtils.getAsHtml(this.background), false);
            ganttDiagram2.draw(uGraphicSvg, 0.0, 0.0);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            ganttDiagram2.draw(uGraphicEps, 0.0, 0.0);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            ganttDiagram2.draw(uGraphicEps, 0.0, 0.0);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private BufferedImage createImage(GanttDiagram2 ganttDiagram2) {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, this.background);
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(this.colorMapper, graphics2D, 1.0);
        double d = ganttDiagram2.getHeight(uGraphicG2d.getStringBounder());
        double d2 = ganttDiagram2.getWidth(uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(d2, d, this.background);
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        uGraphicG2d = new UGraphicG2d(this.colorMapper, graphics2D, 1.0);
        uGraphicG2d.setBufferedImage(bufferedImage);
        ganttDiagram2.draw(uGraphicG2d, 0.0, 0.0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public final Project2 getProject() {
        return this.project;
    }
}

