/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeHeaderMonth
implements TextBlock {
    private final Day start;
    private final Day end;
    private final TimeLine timeline;
    private final double dayWidth;
    private final UFont font = new UFont("Serif", 0, 9);
    private final FontConfiguration fontConfig = new FontConfiguration(this.font, HtmlColorUtils.BLACK);

    public TimeHeaderMonth(Day day, Day day2, TimeLine timeLine, double d) {
        this.start = day;
        this.end = day2;
        this.timeline = timeLine;
        this.dayWidth = d;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        int n = 0;
        String string = null;
        double d3 = -1.0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            String string2 = "" + day.getMonth().name();
            if (d3 == -1.0) {
                d3 = (double)n * this.dayWidth;
                string = string2;
            }
            uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
            uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
            if (!string2.equals(string)) {
                this.manage(uGraphic, d, d2, n, string, d3);
                d3 = (double)n * this.dayWidth;
            }
            string = string2;
            ++n;
            day = (Day)this.timeline.next(day);
        }
        this.manage(uGraphic, d, d2, n, string, d3);
    }

    private void manage(UGraphic uGraphic, double d, double d2, int n, String string, double d3) {
        double d4 = (double)n * this.dayWidth - d3;
        uGraphic.draw(d + d3, d2, new URectangle(d4, this.getHeight()));
        TextBlock textBlock = TextBlockUtils.create(Display.asList(string), this.fontConfig, HorizontalAlignement.LEFT, new SpriteContainerEmpty());
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        double d5 = d4 - dimension2D.getWidth();
        double d6 = this.getHeight() - dimension2D.getHeight();
        textBlock.drawU(uGraphic, d + d3 + d5 / 2.0, d2 + d6 / 2.0);
    }

    private double getHeight() {
        return 20.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = 0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            ++n;
            day = (Day)this.timeline.next(day);
        }
        return new Dimension2DDouble((double)n * this.dayWidth, this.getHeight());
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

