/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.salt.Position;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Positionner {
    private int row;
    private int col;
    private int maxRow;
    private int maxCol;
    private final Map<Element, Position> positions = new LinkedHashMap<Element, Position>();

    public void add(Terminated<Element> terminated) {
        this.positions.put(terminated.getElement(), new Position(this.row, this.col));
        this.updateMax();
        Terminator terminator = terminated.getTerminator();
        if (terminator == Terminator.NEWCOL) {
            ++this.col;
        } else {
            ++this.row;
            this.col = 0;
        }
    }

    private void updateMax() {
        if (this.row > this.maxRow) {
            this.maxRow = this.row;
        }
        if (this.col > this.maxCol) {
            this.maxCol = this.col;
        }
    }

    public Map<Element, Position> getAll() {
        return Collections.unmodifiableMap(this.positions);
    }

    public final int getNbRows() {
        return this.maxRow + 1;
    }

    public final int getNbCols() {
        return this.maxCol + 1;
    }
}

