/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementTreeEntry;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class ElementTree
implements Element {
    private final Collection<ElementTreeEntry> entries = new ArrayList<ElementTreeEntry>();
    private final UFont font;
    private final SpriteContainer spriteContainer;

    public ElementTree(UFont uFont, SpriteContainer spriteContainer) {
        this.font = uFont;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String string) {
        int n = 0;
        while (string.startsWith("+")) {
            ++n;
            string = string.substring(1);
        }
        this.entries.add(new ElementTreeEntry(n, string.trim(), this.font, this.spriteContainer));
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            Dimension2D dimension2D = elementTreeEntry.getPreferredDimension(stringBounder, d, d2);
            d3 = Math.max(d3, dimension2D.getWidth());
            d4 += dimension2D.getHeight();
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        Skeleton skeleton = new Skeleton();
        double d3 = d2;
        for (ElementTreeEntry elementTreeEntry : this.entries) {
            elementTreeEntry.drawU(uGraphic, d, d3, n, dimension2D);
            double d4 = elementTreeEntry.getPreferredDimension(uGraphic.getStringBounder(), d, d3).getHeight();
            skeleton.add(d + elementTreeEntry.getXDelta() - 10.0, d3 + d4 / 2.0 - 1.0);
            d3 += d4;
        }
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        uGraphic.getParam().setColor(HtmlColorUtils.getColorIfValid("#888888"));
        skeleton.draw(uGraphic, d, d2);
        uGraphic.getParam().setColor(htmlColor);
    }

    static class Skeleton {
        private final List<Entry> entries = new ArrayList<Entry>();

        Skeleton() {
        }

        public void add(double d, double d2) {
            this.entries.add(new Entry(d, d2));
        }

        public void draw(UGraphic uGraphic, double d, double d2) {
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                if (i + 1 < this.entries.size() && this.entries.get(i + 1).xpos > entry.xpos) {
                    entry.drawRectangle(uGraphic);
                }
                Entry entry2 = null;
                for (int j = 0; j < i; ++j) {
                    Entry entry3 = this.entries.get(j);
                    if (!(entry3.xpos < entry.xpos)) continue;
                    entry2 = entry3;
                }
                if (entry2 == null) continue;
                this.drawChild(uGraphic, entry2, entry);
            }
        }

        private void drawChild(UGraphic uGraphic, Entry entry, Entry entry2) {
            double d = entry2.ypos - entry.ypos - 2.0;
            uGraphic.draw(entry.xpos + 1.0, entry.ypos + 3.0, new ULine(0.0, d));
            double d2 = entry2.xpos - entry.xpos - 2.0;
            uGraphic.draw(entry.xpos + 1.0, entry2.ypos + 1.0, new ULine(d2, 0.0));
        }

        static class Entry {
            private final double xpos;
            private final double ypos;

            public Entry(double d, double d2) {
                this.xpos = d;
                this.ypos = d2;
            }

            public void drawRectangle(UGraphic uGraphic) {
                uGraphic.draw(this.xpos, this.ypos, new URectangle(2.0, 2.0));
            }
        }
    }
}

