/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class ElementTreeEntry
implements Element {
    private final TextBlock block;
    private final String text;
    private final int level;

    public ElementTreeEntry(int n, String string, UFont uFont, SpriteContainer spriteContainer) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.block = TextBlockUtils.create(Display.asList(string), fontConfiguration, HorizontalAlignement.LEFT, spriteContainer);
        this.text = string;
        this.level = n;
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        return Dimension2DDouble.delta(this.block.calculateDimension(stringBounder), this.getXDelta(), 0.0);
    }

    public double getXDelta() {
        return this.level * 10;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        this.block.drawU(uGraphic, d + this.getXDelta(), d2);
    }

    public String getText() {
        return this.text;
    }
}

