/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrowCrossX
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrowCrossX(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, CommandArrowCrossX.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1LONG", "\"([^\"]+)\""), new RegexLeaf("PART1LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("\\s+"), new RegexLeaf("ARROW", "([=-]+(>?x)|(x<?)[=-]+)"), new RegexLeaf("\\s+"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2LONG", "\"([^\"]+)\""), new RegexLeaf("PART2LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("MESSAGE", "(?::\\s*(.*))?$"));
    }

    private Participant getOrCreateParticipant(RegexResult regexResult, String string) {
        Display display;
        String string2;
        if (regexResult.get(string + "CODE", 0) != null) {
            string2 = regexResult.get(string + "CODE", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONG", 0) != null) {
            string2 = regexResult.get(string + "LONG", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONGCODE", 0) != null) {
            display = Display.getWithNewlines(regexResult.get(string + "LONGCODE", 0));
            string2 = regexResult.get(string + "LONGCODE", 1);
        } else {
            if (regexResult.get(string + "CODELONG", 0) != null) {
                String string3 = regexResult.get(string + "CODELONG", 0);
                Display display2 = Display.getWithNewlines(regexResult.get(string + "CODELONG", 1));
                return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string3, display2);
            }
            throw new IllegalStateException();
        }
        return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string2, display);
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        Participant participant;
        Participant participant2;
        String string = StringUtils.manageArrowForSequence(regexResult.get("ARROW", 0));
        if (string.endsWith("x")) {
            participant2 = this.getOrCreateParticipant(regexResult, "PART1");
            participant = this.getOrCreateParticipant(regexResult, "PART2");
        } else if (string.startsWith("x")) {
            participant = this.getOrCreateParticipant(regexResult, "PART1");
            participant2 = this.getOrCreateParticipant(regexResult, "PART2");
        } else {
            throw new IllegalStateException(regexResult.toString());
        }
        boolean bl = string.contains("--");
        Display display = regexResult.get("MESSAGE", 0) == null ? Display.asList("") : Display.getWithNewlines(regexResult.get("MESSAGE", 0));
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirectionNormal();
        if (bl) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        arrowConfiguration = arrowConfiguration.withDecorationEnd(ArrowDecoration.CROSSX_toberemoved);
        String string2 = ((SequenceDiagram)this.getSystem()).addMessage(new Message(participant2, participant, display, arrowConfiguration, ((SequenceDiagram)this.getSystem()).getNextMessageNumber()));
        if (string2 != null) {
            return CommandExecutionResult.error(string2);
        }
        return CommandExecutionResult.ok();
    }
}

