/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagramFileMaker2
implements FileMaker {
    private static final StringBounder dummyStringBounder;
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private final List<BufferedImage> flashcodes;
    private int offsetX;
    private int offsetY;

    public SequenceDiagramFileMaker2(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption, List<BufferedImage> list) {
        this.flashcodes = list;
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer drawableSetInitializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant object22 : sequenceDiagram.participants().values()) {
            drawableSetInitializer.addParticipant(object22, sequenceDiagram.getEnglober(object22));
        }
        for (Event event : sequenceDiagram.events()) {
            drawableSetInitializer.addEvent(event);
            if (!(event instanceof Message)) continue;
            Message message = (Message)event;
            for (LifeEvent lifeEvent : message.getLiveEvents()) {
                if (lifeEvent.getType() != LifeEventType.DESTROY) continue;
                drawableSetInitializer.addEvent(lifeEvent);
            }
        }
        this.drawableSet = drawableSetInitializer.createDrawableSet(dummyStringBounder);
        ArrayList arrayList = new ArrayList();
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Newpage)) continue;
            arrayList.add((Newpage)event);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Newpage newpage = (Newpage)iterator.next();
            linkedHashMap.put(newpage, drawableSetInitializer.getYposition(dummyStringBounder, newpage));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> map, boolean bl, Display display) {
        double d = drawableSet.getHeadHeight(dummyStringBounder);
        double d2 = drawableSet.getTailHeight(dummyStringBounder, bl);
        double d3 = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Display.asList("")).getPreferredHeight(dummyStringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), d, map, d2, 0.0, d3, display);
    }

    @Override
    public UmlDiagramInfo createOne2(OutputStream outputStream, int n) throws IOException {
        UGraphic uGraphic = this.createImage((int)this.fullDimension.getWidth(), this.pages.get(n), n);
        if (uGraphic instanceof UGraphicG2d) {
            BufferedImage bufferedImage = ((UGraphicG2d)uGraphic).getBufferedImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, this.diagram.getMetadata(), this.diagram.getDpi(this.fileFormatOption));
        } else if (uGraphic instanceof UGraphicSvg) {
            UGraphicSvg uGraphicSvg = (UGraphicSvg)uGraphic;
            uGraphicSvg.createXml(outputStream);
        } else if (uGraphic instanceof UGraphicEps) {
            UGraphicEps uGraphicEps = (UGraphicEps)uGraphic;
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (uGraphic instanceof UGraphicHtml5) {
            UGraphicHtml5 uGraphicHtml5 = (UGraphicHtml5)uGraphic;
            outputStream.write(uGraphicHtml5.generateHtmlCode().getBytes());
        }
        return new UmlDiagramInfo(this.fullDimension.getWidth());
    }

    private double getImageWidth(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d) {
        int n = this.diagram.getMinwidth();
        double d2 = this.getImageWidthWithoutMinsize(sequenceDiagramArea, bl, d);
        if (n == Integer.MAX_VALUE) {
            return d2;
        }
        if (d2 >= (double)n) {
            return d2;
        }
        return n;
    }

    private double getScale(double d, double d2) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(d, d2);
    }

    private double getImageWidthWithoutMinsize(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d) {
        double d2 = bl ? sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d : sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        return d2;
    }

    private double getImageHeight(SequenceDiagramArea sequenceDiagramArea, Page page, boolean bl, double d) {
        if (bl) {
            return sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        }
        return sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
    }

    private UGraphic createImage(int n, Page page, int n2) {
        UGraphic uGraphic;
        double d = 0.0;
        if (n2 > 0) {
            d = page.getNewpage1() - page.getHeaderHeight();
        }
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        SequenceDiagramArea sequenceDiagramArea = new SequenceDiagramArea(n, page.getHeight());
        Component component = null;
        if (page.getTitle() != null) {
            component = this.drawableSet.getSkin().createComponent(ComponentType.TITLE, null, this.drawableSet.getSkinParam(), page.getTitle());
            sequenceDiagramArea.setTitleArea(component.getPreferredWidth(dummyStringBounder), component.getPreferredHeight(dummyStringBounder));
        }
        this.addFooter2(sequenceDiagramArea);
        this.addHeader2(sequenceDiagramArea);
        this.offsetX = (int)Math.round(sequenceDiagramArea.getSequenceAreaX());
        this.offsetY = (int)Math.round(sequenceDiagramArea.getSequenceAreaY());
        Color color = null;
        if (this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(this.diagram.getSkinParam().getBackgroundColor());
        }
        FileFormat fileFormat = this.fileFormatOption.getFileFormat();
        double d2 = this.diagram.getDpiFactor(this.fileFormatOption);
        double d3 = this.getImageWidth(sequenceDiagramArea, this.diagram.isRotation(), d2);
        double d4 = this.getImageWidth(sequenceDiagramArea, false, 1.0);
        if (fileFormat == FileFormat.PNG) {
            double d5 = this.getImageHeight(sequenceDiagramArea, page, false, 1.0);
            if (d5 == 0.0) {
                d5 = 1.0;
            }
            double d6 = 0.0;
            if (this.flashcodes != null) {
                d6 = this.flashcodes.get(0).getHeight();
            }
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d4, d5 + d6);
            uGraphic = this.fileFormatOption.createUGraphic(this.diagram.getSkinParam().getColorMapper(), d2, dimension2DDouble, this.diagram.getSkinParam().getBackgroundColor(), this.diagram.isRotation());
            if (this.flashcodes != null) {
                ((UGraphicG2d)uGraphic).getGraphics2D().drawImage(this.flashcodes.get(0), null, 0, (int)d5);
            }
            AffineTransform affineTransform = ((UGraphicG2d)uGraphic).getGraphics2D().getTransform();
            affineTransform.scale(this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()), this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()));
            ((UGraphicG2d)uGraphic).getGraphics2D().setTransform(affineTransform);
        } else if (fileFormat == FileFormat.SVG) {
            uGraphic = this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorGradient ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), (HtmlColorGradient)this.diagram.getSkinParam().getBackgroundColor(), false) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), false) : new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), StringUtils.getAsHtml(color), false));
        } else if (fileFormat == FileFormat.EPS) {
            uGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.getDefault2());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            uGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.WITH_MACRO_AND_TEXT);
        } else if (fileFormat == FileFormat.HTML5) {
            uGraphic = new UGraphicHtml5(this.diagram.getSkinParam().getColorMapper());
        } else {
            throw new UnsupportedOperationException();
        }
        if (fileFormat != FileFormat.PNG) {
            int n3 = (int)Math.round((d3 - this.getImageWidthWithoutMinsize(sequenceDiagramArea, this.diagram.isRotation(), d2)) / 2.0);
            if (this.diagram.isRotation()) {
                uGraphic.translate(0.0, (double)n3 / d2);
            } else {
                uGraphic.translate((double)n3 / d2, 0.0);
            }
        }
        if (component != null) {
            uGraphic.translate(sequenceDiagramArea.getTitleX(), sequenceDiagramArea.getTitleY());
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d7 = component.getPreferredHeight(stringBounder);
            double d8 = component.getPreferredWidth(stringBounder);
            component.drawU(uGraphic, new Area(new Dimension2DDouble(d8, d7)), new SimpleContext2D(false));
            uGraphic.translate(-sequenceDiagramArea.getTitleX(), -sequenceDiagramArea.getTitleY());
        }
        this.addHeader3(sequenceDiagramArea, uGraphic);
        this.addFooter3(sequenceDiagramArea, uGraphic);
        uGraphic.translate(sequenceDiagramArea.getSequenceAreaX(), sequenceDiagramArea.getSequenceAreaY());
        this.drawableSet.drawU(uGraphic, d, n, page, this.diagram.isShowFootbox());
        return uGraphic;
    }

    private void addFooter2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setFooterArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addHeader2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setHeaderArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addFooter3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic, sequenceDiagramArea.getFooterX(this.diagram.getFooterAlignement()), sequenceDiagramArea.getFooterY());
    }

    private void addHeader3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic, sequenceDiagramArea.getHeaderX(this.diagram.getHeaderAlignement()), sequenceDiagramArea.getHeaderY());
    }

    public static StringBounder getDummystringbounder() {
        return dummyStringBounder;
    }

    @Override
    public void appendCmap(CMapData cMapData) {
        this.drawableSet.appendCmap(cMapData, this.offsetX, this.offsetY, dummyStringBounder, this.diagram);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        dummyStringBounder = StringBounderUtils.asStringBounder(bufferedImage.createGraphics());
    }
}

