/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final Display strings;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final UFont font;
    private final HtmlColor fontColor;
    private Dimension2D size;

    public AbstractTextualComponent(CharSequence charSequence, HtmlColor htmlColor, UFont uFont, HorizontalAlignement horizontalAlignement, int n, int n2, int n3, SpriteContainer spriteContainer) {
        this(Display.asList(charSequence == null ? "" : charSequence), htmlColor, uFont, horizontalAlignement, n, n2, n3, spriteContainer);
    }

    public AbstractTextualComponent(Display display, HtmlColor htmlColor, UFont uFont, HorizontalAlignement horizontalAlignement, int n, int n2, int n3, SpriteContainer spriteContainer) {
        this.font = uFont;
        this.fontColor = htmlColor;
        this.marginX1 = n;
        this.marginX2 = n2;
        this.marginY = n3;
        this.strings = display;
        this.textBlock = display.size() == 1 && display.get(0).length() == 0 ? new TextBlockEmpty() : TextBlockUtils.create(display, new FontConfiguration(uFont, htmlColor), horizontalAlignement, spriteContainer);
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        if (this.size == null) {
            this.size = textBlock.calculateDimension(stringBounder);
        }
        return this.size;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getHeight() + (double)(2 * this.marginY);
    }

    protected final Display getLabels() {
        return this.strings;
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HtmlColor getFontColor() {
        return this.fontColor;
    }
}

