/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickMan
implements TextBlock {
    private final double thickness;
    private final double armsY = 8.0;
    private final double armsLenght = 13.0;
    private final double bodyLenght = 27.0;
    private final double legsX = 13.0;
    private final double legsY = 15.0;
    private final double headDiam = 16.0;
    private final HtmlColor backgroundColor;
    private final HtmlColor foregroundColor;
    private double deltaShadow;

    public void setDeltaShadow(double d) {
        this.deltaShadow = d;
    }

    public StickMan(HtmlColor htmlColor, HtmlColor htmlColor2, double d, double d2) {
        this.backgroundColor = htmlColor;
        this.foregroundColor = htmlColor2;
        this.deltaShadow = d;
        this.thickness = d2;
    }

    public StickMan(HtmlColor htmlColor, HtmlColor htmlColor2, double d) {
        this(htmlColor, htmlColor2, d, 2.0);
    }

    public StickMan(HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(htmlColor, htmlColor2, 0.0, 2.0);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setStroke(new UStroke(this.thickness));
        double d3 = Math.max(13.0, 13.0) - 8.0 + this.thickness;
        UEllipse uEllipse = new UEllipse(16.0, 16.0);
        double d4 = d3 + 8.0;
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(0.0, 27.0);
        uPath.moveTo(-13.0, 8.0);
        uPath.lineTo(13.0, 8.0);
        uPath.moveTo(0.0, 27.0);
        uPath.lineTo(-13.0, 42.0);
        uPath.moveTo(0.0, 27.0);
        uPath.lineTo(13.0, 42.0);
        if (this.deltaShadow != 0.0) {
            uEllipse.setDeltaShadow(this.deltaShadow);
            uPath.setDeltaShadow(this.deltaShadow);
        }
        uGraphic.getParam().setBackcolor(this.backgroundColor);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.draw(d + d3, d2 + this.thickness, uEllipse);
        uGraphic.draw(d + d4, d2 + 16.0 + this.thickness, uPath);
        uGraphic.getParam().setStroke(new UStroke());
    }

    public double getPreferredWidth() {
        return Math.max(13.0, 13.0) * 2.0 + 2.0 * this.thickness;
    }

    public double getPreferredHeight() {
        return 58.0 + 2.0 * this.thickness + this.deltaShadow + 1.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(), this.getPreferredHeight());
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

