/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ComponentBlueModernGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor headerBackgroundColor;
    private final HtmlColor generalBackgroundColor;
    private final HtmlColor borderColor;

    public ComponentBlueModernGroupingHeader(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, HtmlColor htmlColor5, UFont uFont, UFont uFont2, Display display, SpriteContainer spriteContainer) {
        super(display.get(0), htmlColor4, uFont, HorizontalAlignement.LEFT, 15, 30, 1, spriteContainer);
        this.headerBackgroundColor = htmlColor;
        this.generalBackgroundColor = htmlColor2;
        this.borderColor = htmlColor3;
        this.commentTextBlock = display.size() == 1 || display.get(1) == null ? null : TextBlockUtils.create(Display.asList("[" + display.get(1) + "]"), new FontConfiguration(uFont2, htmlColor5), HorizontalAlignement.LEFT, spriteContainer);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d;
        if (this.commentTextBlock == null) {
            d = 0.0;
        } else {
            Dimension2D dimension2D = this.commentTextBlock.calculateDimension(stringBounder);
            d = (double)(this.getMarginX1() + 0) + dimension2D.getWidth();
        }
        return this.getTextWidth(stringBounder) + d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.generalBackgroundColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(0.0, 0.0, new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        uGraphic.getParam().setStroke(new UStroke());
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(0.0, 0.0, new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        uGraphic.getParam().setStroke(new UStroke());
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextWidth(stringBounder);
        int n2 = (int)this.getTextHeight(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.getParam().setBackcolor(this.headerBackgroundColor);
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(0.0, 0.0, new ULine(dimension2D.getWidth(), 0.0));
        double d = dimension2D.getHeight() - this.getPaddingY();
        uGraphic.draw(dimension2D.getWidth(), 0.0, new ULine(0.0, d));
        uGraphic.draw(0.0, n2, new ULine(0.0, d - (double)n2));
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
        if (this.commentTextBlock != null) {
            uGraphic.getParam().setColor(this.generalBackgroundColor);
            int n3 = this.getMarginX1() + n;
            int n4 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(uGraphic, n3 + 0, n4);
        }
    }
}

