/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ComponentBlueModernSelfArrow
extends AbstractComponentBlueModernArrow {
    private final double arrowWidth = 45.0;

    public ComponentBlueModernSelfArrow(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, Display display, ArrowConfiguration arrowConfiguration, SpriteContainer spriteContainer) {
        super(htmlColor, htmlColor2, uFont, display, arrowConfiguration, spriteContainer);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic.getParam().setBackcolor(this.getForegroundColor());
        uGraphic.getParam().setColor(this.getForegroundColor());
        if (this.getArrowConfiguration().isDotted()) {
            this.stroke(uGraphic, 5.0, 2.0);
        } else {
            uGraphic.getParam().setStroke(new UStroke(2.0));
        }
        uGraphic.draw(0.0, n, new ULine(42.0, 0.0));
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        uGraphic.draw(42.0, n, new ULine(0.0, n2 - n));
        uGraphic.draw(42.0, n2, new ULine(-40.0, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        int n3 = (int)this.getArrowOnlyHeight(stringBounder);
        if (this.getArrowConfiguration().isAsync()) {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                uGraphic.draw(this.getArrowDeltaX2(), n - this.getArrowDeltaY2() + n3, new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                uGraphic.draw(this.getArrowDeltaX2(), n + this.getArrowDeltaY2() + n3, new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
            }
            uGraphic.getParam().setStroke(new UStroke());
        } else {
            UPolygon uPolygon = this.getPolygon(n, n3);
            uGraphic.draw(0.0, 0.0, uPolygon);
        }
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), 0.0);
    }

    private UPolygon getPolygon(int n, int n2) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY() + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + n2);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + n2);
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY() + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + n2);
        }
        return uPolygon;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }

    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        return new Point2D.Double(this.getPaddingX(), (double)n2 + this.getPaddingY());
    }
}

