/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ComponentRoseActor
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseActor(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, Display display, boolean bl, SpriteContainer spriteContainer, double d, UStroke uStroke) {
        super(display, htmlColor3, uFont, HorizontalAlignement.CENTER, 3, 3, 0, spriteContainer);
        this.head = bl;
        this.stickman = new StickMan(htmlColor, htmlColor2, d, uStroke.getThickness());
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        uGraphic.getParam().setColor(this.getFontColor());
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.stickman.calculateDimension(stringBounder);
        double d = (this.getPreferredWidth(stringBounder) - dimension2D.getWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(uGraphic, this.getTextMiddlePostion(stringBounder), dimension2D.getHeight());
            uGraphic.translate(d, 0.0);
        } else {
            textBlock.drawU(uGraphic, this.getTextMiddlePostion(stringBounder), 0.0);
            uGraphic.translate(d, this.getTextHeight(stringBounder));
        }
        this.stickman.drawU(uGraphic, 0.0, 0.0);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.stickman.calculateDimension(stringBounder);
        return dimension2D.getHeight() + this.getTextHeight(stringBounder);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.stickman.calculateDimension(stringBounder);
        return Math.max(dimension2D.getWidth(), this.getTextWidth(stringBounder));
    }
}

