/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ComponentRoseGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor groupBackground;
    private final HtmlColor groupBorder;
    private final HtmlColor background;
    private final double deltaShadow;
    private final UStroke stroke;

    public ComponentRoseGroupingHeader(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, UFont uFont, UFont uFont2, Display display, SpriteContainer spriteContainer, double d, UStroke uStroke) {
        super(display.get(0), htmlColor, uFont, HorizontalAlignement.LEFT, 15, 30, 1, spriteContainer);
        this.groupBackground = htmlColor3;
        this.groupBorder = htmlColor4;
        this.background = htmlColor2;
        this.stroke = uStroke;
        this.deltaShadow = d;
        this.commentTextBlock = display.size() == 1 || display.get(1) == null ? null : TextBlockUtils.create(Display.asList("[" + display.get(1) + "]"), new FontConfiguration(uFont2, htmlColor), HorizontalAlignement.LEFT, spriteContainer);
        if (this.background == null) {
            throw new IllegalArgumentException();
        }
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d;
        if (this.commentTextBlock == null) {
            d = 0.0;
        } else {
            Dimension2D dimension2D = this.commentTextBlock.calculateDimension(stringBounder);
            d = (double)(this.getMarginX1() + 0) + dimension2D.getWidth();
        }
        return this.getTextWidth(stringBounder) + d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.getParam().setColor(this.groupBorder);
        uGraphic.getParam().setBackcolor(this.background);
        uGraphic.getParam().setStroke(this.stroke);
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uRectangle.setDeltaShadow(this.deltaShadow);
        uGraphic.draw(0.0, 0.0, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.getParam().setColor(this.groupBorder);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(this.stroke);
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uGraphic.draw(0.0, 0.0, uRectangle);
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextWidth(stringBounder);
        int n2 = (int)this.getTextHeight(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setColor(this.groupBorder);
        uGraphic.getParam().setBackcolor(this.groupBackground);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
        if (this.commentTextBlock != null) {
            int n3 = this.getMarginX1() + n;
            int n4 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(uGraphic, n3 + 0, n4);
        }
    }
}

