/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class ComponentRoseNote
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double paddingX;
    private final double paddingY;
    private final double deltaShadow;
    private final UStroke stroke;

    public ComponentRoseNote(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, Display display, double d, double d2, SpriteContainer spriteContainer, double d3, UStroke uStroke) {
        super(display, htmlColor3, uFont, HorizontalAlignement.LEFT, 6, 15, 5, spriteContainer);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
        this.paddingX = d;
        this.paddingY = d2;
        this.deltaShadow = d3;
        this.stroke = uStroke;
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX() + this.deltaShadow;
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.deltaShadow;
    }

    public double getPaddingX() {
        return this.paddingX;
    }

    public double getPaddingY() {
        return this.paddingY;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        double d = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            n2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, n);
        uPolygon.addPoint(n2, n);
        uPolygon.addPoint(n2, 10.0);
        uPolygon.addPoint(n2 - 10, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.setDeltaShadow(this.deltaShadow);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.getParam().setBackcolor(this.back);
        uGraphic.getParam().setStroke(this.stroke);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(n2 - 10, 0.0, new ULine(0.0, 10.0));
        uGraphic.draw(n2, 10.0, new ULine(-10.0, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, (double)this.getMarginX1() + d / 2.0, this.getMarginY());
    }
}

