/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class StateDiagram
extends AbstractEntityDiagram {
    private boolean hideEmptyDescription = false;

    public IEntity getOrCreateLeaf1(Code code, LeafType leafType) {
        if (leafType == null) {
            if (code.getCode().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroup(code)) {
                return this.getGroup(code);
            }
            return this.getOrCreateLeaf1Default(code, LeafType.STATE);
        }
        return this.getOrCreateLeaf1Default(code, leafType);
    }

    public IEntity getStart() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf1(Code.of("*start"), LeafType.CIRCLE_START);
        }
        return this.getOrCreateLeaf1(Code.of("*start*" + iGroup.getCode().getCode()), LeafType.CIRCLE_START);
    }

    public IEntity getEnd() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf1(Code.of("*end"), LeafType.CIRCLE_END);
        }
        return this.getOrCreateLeaf1(Code.of("*end*" + iGroup.getCode().getCode()), LeafType.CIRCLE_END);
    }

    public IEntity getHistorical() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf1(Code.of("*historical"), LeafType.PSEUDO_STATE);
        }
        return this.getOrCreateLeaf1(Code.of("*historical*" + iGroup.getCode().getCode()), LeafType.PSEUDO_STATE);
    }

    public IEntity getHistorical(Code code) {
        IGroup iGroup = this.getOrCreateGroup(code, Display.getWithNewlines(code), null, GroupType.STATE, this.getRootGroup());
        IEntity iEntity = this.getOrCreateLeaf1(Code.of("*historical*" + iGroup.getCode().getCode()), LeafType.PSEUDO_STATE);
        this.endGroup();
        return iEntity;
    }

    public boolean concurrentState() {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        IGroup iGroup2 = this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.asList(""), null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        if (!EntityUtils.groupRoot(iGroup) && iGroup.zgetGroupType() == GroupType.STATE) {
            iGroup.zmoveEntitiesTo(iGroup2);
            super.endGroup();
            this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.asList(""), null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        }
        return true;
    }

    public void endGroup() {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    public final boolean isHideEmptyDescription() {
        return this.hideEmptyDescription;
    }
}

