/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ClusterDecoration {
    private final PackageStyle style;
    private final USymbol symbol;
    private final TextBlock title;
    private final TextBlock stereo;
    private final HtmlColor stateBack;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    public static final int marginTitleX1 = 3;
    public static final int marginTitleX2 = 3;
    public static final int marginTitleX3 = 7;
    public static final int marginTitleY0 = 0;
    public static final int marginTitleY1 = 3;
    public static final int marginTitleY2 = 3;

    public ClusterDecoration(PackageStyle packageStyle, USymbol uSymbol, TextBlock textBlock, TextBlock textBlock2, HtmlColor htmlColor, double d, double d2, double d3, double d4) {
        this.symbol = uSymbol;
        this.style = packageStyle;
        this.stereo = textBlock2;
        this.title = textBlock;
        this.stateBack = htmlColor;
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
        if (htmlColor instanceof HtmlColorTransparent) {
            throw new UnsupportedOperationException();
        }
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        if (this.symbol != null) {
            SymbolContext symbolContext = new SymbolContext(this.stateBack, htmlColor).withShadow(bl).withStroke(new UStroke(2.0));
            this.symbol.asBig(this.title, this.stereo, this.maxX - this.minX, this.maxY - this.minY, symbolContext).drawU(uGraphic, d + this.minX, d2 + this.minY);
            uGraphic.getParam().setStroke(new UStroke());
            return;
        }
        if (this.style == PackageStyle.NODE) {
            this.drawWithTitleNode(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.DATABASE) {
            this.drawWithTitleDatabase(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.CLOUD) {
            this.drawWithTitleCloud(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.FRAME) {
            this.drawWithTitleFrame(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.RECT) {
            this.drawWithTitleRect(uGraphic, d, d2, htmlColor, bl);
        } else {
            this.drawWithTitleFolder(uGraphic, d, d2, htmlColor, bl);
        }
    }

    private void drawWithTitleCloud(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        PackageStyle.CLOUD.drawU(uGraphic, d + this.minX, d2 + this.minY, new Dimension2DDouble(d3, d4), dimension2D, bl);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + (d3 - dimension2D.getWidth()) / 2.0, d2 + this.minY + 10.0);
    }

    private void drawWithTitleDatabase(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        PackageStyle.DATABASE.drawU(uGraphic, d + this.minX, d2 + this.minY - 10.0, new Dimension2DDouble(d3, d4 + 10.0), dimension2D, bl);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 10.0);
    }

    private void drawWithTitleFrame(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        PackageStyle.FRAME.drawU(uGraphic, d + this.minX, d2 + this.minY, new Dimension2DDouble(d3, d4), dimension2D, bl);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY);
    }

    private void drawWithTitleNode(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        SymbolContext symbolContext = new SymbolContext(this.stateBack, htmlColor).withStroke(new UStroke(2.0)).withShadow(bl);
        USymbol.NODE.asBig(this.title, this.stereo, d3 + 10.0, d4, symbolContext).drawU(uGraphic, d + this.minX, d2 + this.minY);
        uGraphic.getParam().setStroke(new UStroke());
    }

    private UPolygon getSpecificFrontierForFolder(StringBounder stringBounder) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        Dimension2D dimension2D = this.title.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3 + 7.0, d4);
        uPolygon.addPoint(d, d4);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private void drawWithTitleFolder(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = this.getSpecificFrontierForFolder(uGraphic.getStringBounder());
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uPolygon);
        uGraphic.draw(d + this.minX, d2 + this.minY + d4, new ULine(d3 + 7.0, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 3.0);
    }

    private void drawWithTitleRect(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = d3 - dimension2D.getWidth();
        this.title.drawU(uGraphic, d + this.minX + d5 / 2.0, d2 + this.minY + 5.0);
    }
}

