/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.EnumSet;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PackageStyle {
    FOLDER,
    RECT,
    NODE,
    FRAME,
    CLOUD,
    DATABASE,
    AGENT,
    STORAGE,
    COMPONENT1,
    COMPONENT2,
    ARTIFACT;


    public static PackageStyle fromString(String string) {
        for (PackageStyle packageStyle : EnumSet.allOf(PackageStyle.class)) {
            if (!packageStyle.toString().equalsIgnoreCase(string)) continue;
            return packageStyle;
        }
        return null;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, Dimension2D dimension2D, Dimension2D dimension2D2, boolean bl) {
        if (dimension2D2 == null) {
            dimension2D2 = new Dimension2DDouble(0.0, 0.0);
        }
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        if (this == DATABASE) {
            this.drawDatabase(uGraphic, d, d2, d3, d4, bl);
        } else if (this == FOLDER) {
            this.drawFolder(uGraphic, d, d2, d3, d4, bl);
        } else if (this == FRAME) {
            this.drawFrame(uGraphic, d, d2, d3, d4, dimension2D2, bl);
        } else if (this == CLOUD) {
            this.drawCloud(uGraphic, d, d2, d3, d4, bl);
        } else if (this == RECT) {
            this.drawRect(uGraphic, d, d2, d3, d4, bl);
        } else if (this == COMPONENT1) {
            this.drawComponent1(uGraphic, d, d2, d3, d4, bl);
        } else if (this == COMPONENT2) {
            this.drawComponent2(uGraphic, d, d2, d3, d4, bl);
        } else if (this == STORAGE) {
            this.drawStorage(uGraphic, d, d2, d3, d4, bl);
        } else if (this == AGENT) {
            this.drawRect(uGraphic, d, d2, d3, d4, bl);
        } else if (this == ARTIFACT) {
            this.drawArtifact(uGraphic, d, d2, d3, d4, bl);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void drawArtifact(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(d3, d4);
        uPolygon.addPoint(d3, 10.0);
        uPolygon.addPoint(d3 - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.draw(d + d3 - 10.0, d2, new ULine(0.0, 10.0));
        uGraphic.draw(d + d3, d2 + 10.0, new ULine(-10.0, 0.0));
    }

    private void drawStorage(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        URectangle uRectangle = new URectangle(d3, d4, 70.0, 70.0);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uRectangle);
    }

    private void drawComponent1(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(4.0);
        }
        URectangle uRectangle2 = new URectangle(10.0, 5.0);
        uGraphic.draw(d, d2, uRectangle);
        uGraphic.draw(d - 5.0, d2 + 5.0, uRectangle2);
        uGraphic.draw(d - 5.0, d2 + d4 - 10.0, uRectangle2);
    }

    private void drawComponent2(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(4.0);
        }
        URectangle uRectangle2 = new URectangle(15.0, 10.0);
        URectangle uRectangle3 = new URectangle(4.0, 2.0);
        uGraphic.draw(d, d2, uRectangle);
        uGraphic.draw(d + d3 - 20.0, d2 + 5.0, uRectangle2);
        uGraphic.draw(d + d3 - 22.0, d2 + 7.0, uRectangle3);
        uGraphic.draw(d + d3 - 22.0, d2 + 11.0, uRectangle3);
    }

    private void drawRect(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uRectangle);
    }

    private void drawCloud(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPath uPath = this.getSpecificFrontierForCloud(d3, d4);
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uGraphic.draw(d + 3.0, d2 - 3.0, uPath);
    }

    private UPath getSpecificFrontierForCloud(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 10.0);
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d - 9.0) {
            uPath.cubicTo(0 + n, 7.0, 2 + n, 5.0, 5 + n, 5.0);
            uPath.cubicTo(8 + n, 5.0, 10 + n, 7.0, 10 + n, 10.0);
            d3 = n + 10;
            n += 10;
        }
        double d4 = 0.0;
        int n2 = 10;
        while ((double)n2 < d2 - 9.0) {
            uPath.cubicTo(d3 + 3.0, 0 + n2, d3 + 5.0, 2 + n2, d3 + 5.0, 5 + n2);
            uPath.cubicTo(d3 + 5.0, 8 + n2, d3 + 3.0, 10 + n2, d3, 10 + n2);
            d4 = n2 + 10;
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d - 9.0) {
            uPath.cubicTo(d3 - (double)n2, d4 + 3.0, d3 - 3.0 - (double)n2, d4 + 5.0, d3 - 5.0 - (double)n2, d4 + 5.0);
            uPath.cubicTo(d3 - 8.0 - (double)n2, d4 + 5.0, d3 - 10.0 - (double)n2, d4 + 3.0, d3 - 10.0 - (double)n2, d4);
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d2 - 9.0 - 10.0) {
            uPath.cubicTo(-3.0, d4 - (double)n2, -5.0, d4 - 2.0 - (double)n2, -5.0, d4 - 5.0 - (double)n2);
            uPath.cubicTo(-5.0, d4 - 8.0 - (double)n2, -3.0, d4 - 10.0 - (double)n2, 0.0, d4 - 10.0 - (double)n2);
            n2 += 10;
        }
        return uPath;
    }

    private void drawFrame(UGraphic uGraphic, double d, double d2, double d3, double d4, Dimension2D dimension2D, boolean bl) {
        int n;
        double d5;
        double d6;
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uRectangle);
        if (dimension2D.getWidth() == 0.0) {
            d6 = d3 / 3.0;
            d5 = 12.0;
            n = 7;
        } else {
            d6 = dimension2D.getWidth() + 10.0;
            d5 = dimension2D.getHeight() + 3.0;
            n = 10;
        }
        UPath uPath = new UPath();
        uPath.moveTo(d6, 1.0);
        uPath.lineTo(d6, d5 - (double)n);
        uPath.lineTo(d6 - (double)n, d5);
        uPath.lineTo(0.0, d5);
        uGraphic.draw(d, d2, uPath);
    }

    private void drawFolder(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.max(30.0, d3 / 4.0);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d5, 0.0);
        uPolygon.addPoint(d5 + 7.0, 10.0);
        uPolygon.addPoint(d3, 10.0);
        uPolygon.addPoint(d3, d4);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.draw(d, d2 + 10.0, new ULine(d5 + 7.0, 0.0));
    }

    private void drawDatabase(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(0.0, 10.0);
        uPath.cubicTo(10.0, 0.0, d3 / 2.0 - 10.0, 0.0, d3 / 2.0, 0.0);
        uPath.cubicTo(d3 / 2.0 + 10.0, 0.0, d3 - 10.0, 0.0, d3, 10.0);
        uPath.lineTo(d3, d4 - 10.0);
        uPath.cubicTo(d3 - 10.0, d4, d3 / 2.0 - 10.0, d4, d3 / 2.0, d4);
        uPath.cubicTo(d3 / 2.0 + 10.0, d4, 10.0, d4, 0.0, d4 - 10.0);
        uPath.lineTo(0.0, 10.0);
        uGraphic.draw(d, d2, uPath);
        UPath uPath2 = new UPath();
        uPath2.moveTo(0.0, 10.0);
        uPath2.cubicTo(10.0, 20.0, d3 / 2.0 - 10.0, 20.0, d3 / 2.0, 20.0);
        uPath2.cubicTo(d3 / 2.0 + 10.0, 20.0, d3 - 10.0, 20.0, d3, 10.0);
        uGraphic.draw(d, d2, uPath2);
    }

    private void drawNode(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 10.0);
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3, d4 - 10.0);
        uPolygon.addPoint(d3 - 10.0, d4);
        uPolygon.addPoint(0.0, d4);
        uPolygon.addPoint(0.0, 10.0);
        if (bl) {
            uPolygon.setDeltaShadow(2.0);
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.draw(d + d3 - 10.0, d2 + 10.0, new ULine(9.0, -9.0));
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(d3 - 10.0, 0.0);
        uPath.lineTo(d3 - 10.0, d4 - 10.0);
        uGraphic.draw(d, d2 + 10.0, uPath);
    }
}

