/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageState
extends AbstractEntityImage {
    private final TextBlock desc;
    private final TextBlock fields;
    private final List<Url> url;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private final boolean withSymbol;
    private static final double smallRadius = 3.0;
    private static final double smallLine = 3.0;
    private static final double smallMarginX = 7.0;
    private static final double smallMarginY = 4.0;

    public EntityImageState(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        this.desc = TextBlockUtils.create(iEntity.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        Display display = new Display();
        for (Member member : iEntity.getFieldsToDisplay()) {
            display = display.addAll(Display.getWithNewlines(member.getDisplay(true)));
        }
        this.url = iEntity.getUrls();
        this.fields = TextBlockUtils.create(display, new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype)), HorizontalAlignement.LEFT, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.fields.calculateDimension(stringBounder));
        double d = 0.0;
        if (this.withSymbol) {
            d += 10.0;
        }
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, 20.0 + d);
        return Dimension2DDouble.atLeast(dimension2D2, 50.0, 50.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        double d3;
        double d4;
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.desc.calculateDimension(stringBounder);
        double d5 = dimension2D.getWidth();
        double d6 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d5, d6, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        uGraphic.draw(d, d2, uRectangle);
        double d7 = d2 + 5.0 + dimension2D2.getHeight() + 5.0;
        uGraphic.draw(d, d7, new ULine(d5, 0.0));
        uGraphic.getParam().setStroke(new UStroke(1.3));
        uGraphic.getParam().setStroke(new UStroke());
        if (this.withSymbol) {
            d4 = d + dimension2D.getWidth();
            d3 = d2 + dimension2D.getHeight();
            EntityImageState.drawSymbol(uGraphic, d4, d3);
        }
        d4 = (d5 - dimension2D2.getWidth()) / 2.0;
        d3 = d2 + 5.0;
        this.desc.drawU(uGraphic, d + d4, d3);
        double d8 = d + 5.0;
        double d9 = d7 + 5.0;
        this.fields.drawU(uGraphic, d8, d9);
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public static void drawSymbol(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = new UEllipse(6.0, 6.0);
        uGraphic.draw(d -= 22.0, d2 -= 10.0, uEllipse);
        uGraphic.draw(d + 3.0 + 6.0, d2, uEllipse);
        uGraphic.draw(d + 6.0, d2 + 3.0, new ULine(3.0, 0.0));
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

