/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.TextBlockInEllipse;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageUseCase
extends AbstractEntityImage {
    private final TextBlock desc;
    private final List<Url> url;

    public EntityImageUseCase(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        BodyEnhanced2 bodyEnhanced2 = new BodyEnhanced2(iLeaf.getDisplay(), FontParam.USECASE, iSkinParam, HorizontalAlignement.CENTER, stereotype, true, false);
        if (stereotype == null || stereotype.getLabel() == null) {
            this.desc = bodyEnhanced2;
        } else {
            TextBlock textBlock = TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.USECASE_ACTOR_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.USECASE_ACTOR_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
            this.desc = TextBlockUtils.mergeTB(textBlock, bodyEnhanced2, HorizontalAlignement.CENTER);
        }
        this.url = iLeaf.getUrls();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        TextBlockInEllipse textBlockInEllipse = new TextBlockInEllipse(this.desc, stringBounder);
        if (this.getSkinParam().shadowing()) {
            textBlockInEllipse.setDeltaShadow(3.0);
        }
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.usecaseBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.usecaseBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        MyUGraphic myUGraphic = new MyUGraphic(uGraphic, d, d2, textBlockInEllipse.getUEllipse());
        textBlockInEllipse.drawU(myUGraphic, d, d2);
        uGraphic.getParam().setStroke(new UStroke());
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    public int getShield() {
        return 0;
    }

    static class MyUGraphic
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        MyUGraphic(UGraphic uGraphic, double d, double d2, UEllipse uEllipse) {
            super(uGraphic);
            this.startingX = d;
            this.ellipse = uEllipse;
            this.yTheoricalPosition = d2;
        }

        private double getNormalized(double d) {
            if (d < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((d -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return d;
        }

        private double getStartingX(double d) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(d));
        }

        private double getEndingX(double d) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(d));
        }

        protected void drawHline(UGraphic uGraphic, double d, double d2, UHorizontalLine uHorizontalLine) {
            uHorizontalLine.drawLine(uGraphic, this.getStartingX(d2), this.getEndingX(d2), d2);
        }
    }
}

