/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;

public class UEllipse
extends AbstractShadowable {
    private final double width;
    private final double height;
    private final double start;
    private final double extend;

    public UEllipse(double d, double d2) {
        this(d, d2, 0.0, 0.0);
    }

    public UEllipse(double d, double d2, double d3, double d4) {
        this.width = d;
        this.height = d2;
        this.start = d3;
        this.extend = d4;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public final double getStart() {
        return this.start;
    }

    public final double getExtend() {
        return this.extend;
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public UEllipse bigger(double d) {
        UEllipse uEllipse = new UEllipse(this.width + d, this.height + d);
        uEllipse.setDeltaShadow(this.getDeltaShadow());
        return uEllipse;
    }

    public double getStartingX(double d) {
        d = d / this.height * 2.0;
        double d2 = 1.0 - Math.sqrt(1.0 - (d - 1.0) * (d - 1.0));
        return d2 * this.width / 2.0;
    }

    public double getEndingX(double d) {
        d = d / this.height * 2.0;
        double d2 = 1.0 + Math.sqrt(1.0 - (d - 1.0) * (d - 1.0));
        return d2 * this.width / 2.0;
    }
}

