/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.EpsGraphicsMacroAndText;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextEps
implements UDriver<EpsGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;
    private final FontRenderContext fontRenderContext;
    private final Graphics2D g2dummy;
    private final EpsStrategy strategy;

    public DriverTextEps(Graphics2D graphics2D, ClipContainer clipContainer, EpsStrategy epsStrategy) {
        this.stringBounder = StringBounderUtils.asStringBounder(graphics2D);
        this.clipContainer = clipContainer;
        this.fontRenderContext = graphics2D.getFontRenderContext();
        this.g2dummy = graphics2D;
        this.strategy = epsStrategy;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        int n;
        Object object;
        Dimension2D dimension2D;
        Object object2;
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null && !uClip.isInside(d, d2)) {
            return;
        }
        UText uText = (UText)uShape;
        if (this.strategy == EpsStrategy.WITH_MACRO_AND_TEXT) {
            this.drawAsText(uText, d, d2, uParam, epsGraphics, colorMapper);
            return;
        }
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont();
        TextLayout textLayout = new TextLayout(uText.getText(), uFont.getFont(), this.fontRenderContext);
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        DriverTextEps.drawPathIterator(epsGraphics, d, d2, textLayout.getOutline(null).getPathIterator(null));
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            object2 = fontConfiguration.getExtendedColor();
            if (object2 != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor((HtmlColor)object2));
            }
            dimension2D = DriverTextG2d.calculateDimension(this.stringBounder, uFont, uText.getText());
            epsGraphics.setStrokeWidth("1.1", 0.0, 0.0);
            epsGraphics.epsLine(d, d2 + 1.5, d + dimension2D.getWidth(), d2 + 1.5);
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            object2 = DriverTextG2d.calculateDimension(this.stringBounder, uFont, uText.getText());
            int n2 = (int)(d2 + 2.5) - 1;
            object = fontConfiguration.getExtendedColor();
            if (object != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor((HtmlColor)object));
            }
            epsGraphics.setStrokeWidth("1.1", 0.0, 0.0);
            n = (int)d;
            while ((double)n < d + ((Dimension2D)object2).getWidth() - 5.0) {
                epsGraphics.epsLine(n, n2 - 0, n + 3, n2 + 1);
                epsGraphics.epsLine(n + 3, n2 + 1, n + 6, n2 - 0);
                n += 6;
            }
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            object2 = fontConfiguration.getExtendedColor();
            if (object2 != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor((HtmlColor)object2));
            }
            dimension2D = DriverTextG2d.calculateDimension(this.stringBounder, uFont, uText.getText());
            object = this.g2dummy.getFontMetrics(uFont.getFont());
            n = (int)(d2 - (double)((FontMetrics)object).getDescent() - 0.5);
            epsGraphics.setStrokeWidth("1.3", 0.0, 0.0);
            epsGraphics.epsLine(d, n, d + dimension2D.getWidth(), n);
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
    }

    private void drawAsText(UText uText, double d, double d2, UParam uParam, EpsGraphics epsGraphics, ColorMapper colorMapper) {
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        double d3 = d2 - 1.0;
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        ((EpsGraphicsMacroAndText)epsGraphics).drawText(uText.getText(), fontConfiguration, d, d3);
    }

    static void drawPathIterator(EpsGraphics epsGraphics, double d, double d2, PathIterator pathIterator) {
        epsGraphics.newpath();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                epsGraphics.moveto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 1) {
                epsGraphics.lineto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 4) {
                epsGraphics.closepath();
            } else if (n == 3) {
                epsGraphics.curveto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2, dArray[4] + d, dArray[5] + d2);
            } else if (n == 2) {
                epsGraphics.quadto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2);
            } else {
                throw new UnsupportedOperationException("code=" + n);
            }
            pathIterator.next();
        }
        epsGraphics.fill(pathIterator.getWindingRule());
    }
}

