/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.object;

import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

public class ObjectDispatchInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ObjectDispatchInInterceptor.class);

    public ObjectDispatchInInterceptor() {
        super("read");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        if (Boolean.TRUE.equals(message.get("org.apache.cxf.client"))) {
            return;
        }
        QName opName = (QName)message.get("objectBinding.operationName");
        QName bindingName = (QName)message.get("objectBinding.bindingName");
        if (opName == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION", BUNDLE, new Object[0]));
        }
        Endpoint ep = message.getExchange().get(Endpoint.class);
        BindingInfo binding = null;
        binding = bindingName == null ? ep.getEndpointInfo().getBinding() : ep.getEndpointInfo().getService().getBinding(bindingName);
        BindingOperationInfo bop = binding.getOperation(opName);
        message.getExchange().put(BindingOperationInfo.class, bop);
    }
}

