/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.wadl.DocumentationProvider;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class JavaDocProvider
implements DocumentationProvider {
    public static final double JAVA_VERSION = JavaDocProvider.getVersion();
    public static final double JAVA_VERSION_16 = 1.6;
    private ClassLoader javaDocLoader;
    private ConcurrentHashMap<String, ClassDocs> docs = new ConcurrentHashMap();
    private double javaDocsBuiltByVersion = JAVA_VERSION;

    public JavaDocProvider(URL javaDocUrl) {
        if (javaDocUrl == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.javaDocLoader = new URLClassLoader(new URL[]{javaDocUrl});
    }

    public JavaDocProvider(String path) throws Exception {
        this(BusFactory.getDefaultBus(), path);
    }

    public JavaDocProvider(Bus bus, String path) throws Exception {
        this(ResourceUtils.getResourceURL(path, bus));
    }

    private static double getVersion() {
        String version = System.getProperty("java.version");
        try {
            return Double.parseDouble(version.substring(0, 3));
        }
        catch (Exception ex) {
            return 1.6;
        }
    }

    @Override
    public String getClassDoc(ClassResourceInfo cri) {
        try {
            ClassDocs doc = this.getClassDocInternal(cri);
            if (doc == null) {
                return null;
            }
            return doc.getClassInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getMethodDoc(OperationResourceInfo ori) {
        try {
            MethodDocs doc = this.getOperationDocInternal(ori);
            if (doc == null) {
                return null;
            }
            return doc.getMethodInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getMethodResponseDoc(OperationResourceInfo ori) {
        try {
            MethodDocs doc = this.getOperationDocInternal(ori);
            if (doc == null) {
                return null;
            }
            return doc.getResponseInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getMethodParameterDoc(OperationResourceInfo ori, int paramIndex) {
        try {
            MethodDocs doc = this.getOperationDocInternal(ori);
            if (doc == null) {
                return null;
            }
            List<String> params = doc.getParamInfo();
            if (paramIndex < params.size()) {
                return params.get(paramIndex);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class<?> getPathAnnotatedClass(Class<?> cls) {
        if (cls.getAnnotation(Path.class) != null) {
            return cls;
        }
        if (cls.getSuperclass().getAnnotation(Path.class) != null) {
            return cls.getSuperclass();
        }
        for (Class<?> i : cls.getInterfaces()) {
            if (i.getAnnotation(Path.class) == null) continue;
            return i;
        }
        return cls;
    }

    private ClassDocs getClassDocInternal(ClassResourceInfo cri) throws Exception {
        String qualifier;
        String classMarker;
        String doc;
        int index;
        InputStream resourceStream;
        Class<?> annotatedClass = this.getPathAnnotatedClass(cri.getServiceClass());
        String resource = annotatedClass.getName().replace(".", "/") + ".html";
        ClassDocs classDocs = this.docs.get(resource);
        if (classDocs == null && (resourceStream = this.javaDocLoader.getResourceAsStream(resource)) != null && (index = (doc = IOUtils.readStringFromStream(resourceStream)).indexOf(classMarker = (qualifier = annotatedClass.isInterface() ? "Interface" : "Class") + " " + annotatedClass.getSimpleName())) != -1) {
            String classInfoTag = this.getClassInfoTag();
            String classInfo = this.getJavaDocText(doc, classInfoTag, "Method Summary", index + classMarker.length());
            classDocs = new ClassDocs(doc, classInfo);
            this.docs.putIfAbsent(resource, classDocs);
        }
        return classDocs;
    }

    private MethodDocs getOperationDocInternal(OperationResourceInfo ori) throws Exception {
        ClassDocs classDoc = this.getClassDocInternal(ori.getClassResourceInfo());
        if (classDoc == null) {
            return null;
        }
        Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
        MethodDocs mDocs = classDoc.getMethodDocs(method);
        if (mDocs == null) {
            String operLink = this.getOperLink();
            String operMarker = operLink + method.getName() + "(";
            int operMarkerIndex = classDoc.getClassDoc().indexOf(operMarker);
            while (operMarkerIndex != -1) {
                String[] opBits;
                int startOfOpSigIndex = operMarkerIndex + operMarker.length();
                int endOfOpSigIndex = classDoc.getClassDoc().indexOf(")", startOfOpSigIndex);
                int paramLen = method.getParameterTypes().length;
                if (endOfOpSigIndex == startOfOpSigIndex && paramLen == 0 || endOfOpSigIndex > startOfOpSigIndex + 1 && (opBits = classDoc.getClassDoc().substring(operMarkerIndex, endOfOpSigIndex).split(",")).length == paramLen) break;
                operMarkerIndex = classDoc.getClassDoc().indexOf(operMarker, operMarkerIndex + operMarker.length());
            }
            if (operMarkerIndex == -1) {
                return null;
            }
            String operDoc = classDoc.getClassDoc().substring(operMarkerIndex + operMarker.length());
            String operInfoTag = this.getOperInfoTag();
            String operInfo = this.getJavaDocText(operDoc, operInfoTag, operLink, 0);
            String responseInfo = null;
            LinkedList<String> paramDocs = new LinkedList<String>();
            if (!StringUtils.isEmpty(operInfo)) {
                int paramIndex;
                int returnsIndex = operDoc.indexOf("Returns:", operLink.length());
                int nextOpIndex = operDoc.indexOf(operLink);
                if (returnsIndex != -1 && (nextOpIndex > returnsIndex || nextOpIndex == -1)) {
                    responseInfo = this.getJavaDocText(operDoc, this.getResponseMarker(), operLink, returnsIndex + 8);
                }
                if ((paramIndex = operDoc.indexOf("Parameters:")) != -1 && (nextOpIndex == -1 || paramIndex < nextOpIndex)) {
                    String paramString = returnsIndex == -1 ? operDoc.substring(paramIndex) : operDoc.substring(paramIndex, returnsIndex);
                    String codeTag = this.getCodeTag();
                    int codeIndex = paramString.indexOf(codeTag);
                    while (codeIndex != -1) {
                        String param;
                        int next = paramString.indexOf("<", codeIndex + 7);
                        if (next == -1) {
                            next = paramString.length();
                        }
                        if ((param = paramString.substring(codeIndex + 7, next).trim()).startsWith("-")) {
                            param = param.substring(1).trim();
                        }
                        paramDocs.add(param);
                        if (next == paramString.length()) break;
                        codeIndex = next + 1;
                        codeIndex = paramString.indexOf(codeTag, codeIndex);
                    }
                }
            }
            mDocs = new MethodDocs(operInfo, paramDocs, responseInfo);
            classDoc.addMethodDocs(method, mDocs);
        }
        return mDocs;
    }

    private String getJavaDocText(String doc, String tag, String notAfterTag, int index) {
        int nextIndex;
        int notAfterIndex;
        int tagIndex = doc.indexOf(tag, index);
        if (tagIndex != -1 && ((notAfterIndex = doc.indexOf(notAfterTag, index)) == -1 || notAfterIndex > tagIndex) && (nextIndex = doc.indexOf("<", tagIndex + tag.length())) != -1) {
            return doc.substring(tagIndex + tag.length(), nextIndex).trim();
        }
        return null;
    }

    protected String getClassInfoTag() {
        if (this.javaDocsBuiltByVersion == 1.6) {
            return "<P>";
        }
        return "<div class=\"block\">";
    }

    protected String getOperInfoTag() {
        if (this.javaDocsBuiltByVersion == 1.6) {
            return "<DD>";
        }
        return "<div class=\"block\">";
    }

    protected String getOperLink() {
        String operLink = "<A NAME=\"";
        return this.javaDocsBuiltByVersion == 1.6 ? operLink : operLink.toLowerCase();
    }

    protected String getResponseMarker() {
        String tag = "<DD>";
        return this.javaDocsBuiltByVersion == 1.6 ? tag : tag.toLowerCase();
    }

    protected String getCodeTag() {
        String tag = "</CODE>";
        return this.javaDocsBuiltByVersion == 1.6 ? tag : tag.toLowerCase();
    }

    public void setJavaDocsBuiltByVersion(String version) {
        this.javaDocsBuiltByVersion = Double.valueOf(version);
    }

    private static class MethodDocs {
        private String methodInfo;
        private List<String> paramInfo = new LinkedList<String>();
        private String responseInfo;

        public MethodDocs(String methodInfo, List<String> paramInfo, String responseInfo) {
            this.methodInfo = methodInfo;
            this.paramInfo = paramInfo;
            this.responseInfo = responseInfo;
        }

        public String getMethodInfo() {
            return this.methodInfo;
        }

        public List<String> getParamInfo() {
            return this.paramInfo;
        }

        public String getResponseInfo() {
            return this.responseInfo;
        }
    }

    private static class ClassDocs {
        private String classDoc;
        private String classInfo;
        private ConcurrentHashMap<Method, MethodDocs> mdocs = new ConcurrentHashMap();

        public ClassDocs(String classDoc, String classInfo) {
            this.classDoc = classDoc;
            this.classInfo = classInfo;
        }

        public String getClassDoc() {
            return this.classDoc;
        }

        public String getClassInfo() {
            return this.classInfo;
        }

        public MethodDocs getMethodDocs(Method method) {
            return this.mdocs.get(method);
        }

        public void addMethodDocs(Method method, MethodDocs doc) {
            this.mdocs.putIfAbsent(method, doc);
        }
    }
}

