/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractJsonpOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected AbstractJsonpOutInterceptor(String phase) {
        super(phase);
    }

    protected String getCallbackValue(Message message) {
        Exchange exchange = message.getExchange();
        return (String)exchange.get("JSONP.CALLBACK");
    }

    protected void writeValue(Message message, String value) throws Fault {
        try {
            this.getOutputStream(message).write(value.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    private OutputStream getOutputStream(Message message) throws IOException {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            HttpServletResponse response = (HttpServletResponse)message.get("HTTP.RESPONSE");
            os = response.getOutputStream();
        }
        return os;
    }
}

