/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.common.util.CompressionUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.oauth2.utils.Base64UrlUtility;
import org.apache.cxf.rs.security.oauth2.utils.EncryptionException;
import org.apache.cxf.rs.security.oauth2.utils.SecretKeyProperties;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static String encodeSecretKey(SecretKey key) throws EncryptionException {
        return EncryptionUtils.encodeBytes(key.getEncoded());
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey) throws EncryptionException {
        SecretKeyProperties props = new SecretKeyProperties();
        props.setCompressionSupported(false);
        return EncryptionUtils.encryptSecretKey(secretKey, publicKey, props);
    }

    public static String encryptSecretKey(SecretKey secretKey, PublicKey publicKey, SecretKeyProperties props) throws EncryptionException {
        byte[] encryptedBytes = EncryptionUtils.encryptBytes(secretKey.getEncoded(), publicKey, props);
        return EncryptionUtils.encodeBytes(encryptedBytes);
    }

    public static SecretKey getSecretKey() throws Exception {
        return EncryptionUtils.getSecretKey("AES");
    }

    public static SecretKey getSecretKey(String symEncAlgo) throws EncryptionException {
        return EncryptionUtils.getSecretKey(new SecretKeyProperties(symEncAlgo));
    }

    public static SecretKey getSecretKey(SecretKeyProperties props) throws EncryptionException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(props.getKeyAlgo());
            AlgorithmParameterSpec algoSpec = props.getAlgoSpec();
            SecureRandom random = props.getSecureRandom();
            if (algoSpec != null) {
                if (random != null) {
                    keyGen.init(algoSpec, random);
                } else {
                    keyGen.init(algoSpec);
                }
            } else if (random != null) {
                keyGen.init(props.getKeySize(), random);
            } else {
                keyGen.init(props.getKeySize());
            }
            return keyGen.generateKey();
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }

    public static String decryptSequence(String encodedToken, String encodedSecretKey) throws EncryptionException {
        return EncryptionUtils.decryptSequence(encodedToken, encodedSecretKey, new SecretKeyProperties("AES"));
    }

    public static String decryptSequence(String encodedData, String encodedSecretKey, SecretKeyProperties props) throws EncryptionException {
        SecretKey key = EncryptionUtils.decodeSecretKey(encodedSecretKey, props.getKeyAlgo());
        return EncryptionUtils.decryptSequence(encodedData, key, props);
    }

    public static String decryptSequence(String encodedData, Key secretKey) throws EncryptionException {
        return EncryptionUtils.decryptSequence(encodedData, secretKey, null);
    }

    public static String decryptSequence(String encodedData, Key secretKey, SecretKeyProperties props) throws EncryptionException {
        byte[] encryptedBytes = EncryptionUtils.decodeSequence(encodedData);
        byte[] bytes = EncryptionUtils.decryptBytes(encryptedBytes, secretKey, props);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }

    public static String encryptSequence(String sequence, Key secretKey) throws EncryptionException {
        return EncryptionUtils.encryptSequence(sequence, secretKey, null);
    }

    public static String encryptSequence(String sequence, Key secretKey, SecretKeyProperties keyProps) throws EncryptionException {
        try {
            byte[] bytes = EncryptionUtils.encryptBytes(sequence.getBytes("UTF-8"), secretKey, keyProps);
            return EncryptionUtils.encodeBytes(bytes);
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }

    public static String encodeBytes(byte[] bytes) throws EncryptionException {
        try {
            return Base64UrlUtility.encode(bytes);
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey) throws EncryptionException {
        return EncryptionUtils.encryptBytes(bytes, secretKey, null);
    }

    public static byte[] encryptBytes(byte[] bytes, Key secretKey, SecretKeyProperties keyProps) throws EncryptionException {
        return EncryptionUtils.processBytes(bytes, secretKey, keyProps, 1);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey) throws EncryptionException {
        return EncryptionUtils.decryptBytes(bytes, secretKey, null);
    }

    public static byte[] decryptBytes(byte[] bytes, Key secretKey, SecretKeyProperties keyProps) throws EncryptionException {
        return EncryptionUtils.processBytes(bytes, secretKey, keyProps, 2);
    }

    private static byte[] processBytes(byte[] bytes, Key secretKey, SecretKeyProperties keyProps, int mode) throws EncryptionException {
        boolean compressionSupported;
        boolean bl = compressionSupported = keyProps != null && keyProps.isCompressionSupported();
        if (compressionSupported && mode == 1) {
            bytes = CompressionUtils.deflate(bytes, false);
        }
        try {
            int blockSize;
            Cipher c = Cipher.getInstance(secretKey.getAlgorithm());
            if (keyProps == null || keyProps.getAlgoSpec() == null && keyProps.getSecureRandom() == null) {
                c.init(mode, secretKey);
            } else {
                AlgorithmParameterSpec algoSpec = keyProps.getAlgoSpec();
                SecureRandom random = keyProps.getSecureRandom();
                if (algoSpec == null) {
                    c.init(mode, secretKey, random);
                } else if (random == null) {
                    c.init(mode, secretKey, algoSpec);
                } else {
                    c.init(mode, secretKey, algoSpec, random);
                }
            }
            byte[] result = new byte[]{};
            int n = blockSize = keyProps != null ? keyProps.getBlockSize() : -1;
            if (secretKey instanceof SecretKey && blockSize == -1) {
                result = c.doFinal(bytes);
            } else {
                if (blockSize == -1) {
                    blockSize = secretKey instanceof PublicKey ? 117 : 128;
                }
                int offset = 0;
                while (offset + blockSize < bytes.length) {
                    result = EncryptionUtils.addToResult(result, c.doFinal(bytes, offset, blockSize));
                    offset += blockSize;
                }
                if (offset < bytes.length) {
                    result = EncryptionUtils.addToResult(result, c.doFinal(bytes, offset, bytes.length - offset));
                }
            }
            if (compressionSupported && mode == 2) {
                result = IOUtils.readBytesFromStream(CompressionUtils.inflate(result, false));
            }
            return result;
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }

    private static byte[] addToResult(byte[] prefix, byte[] suffix) {
        byte[] result = new byte[prefix.length + suffix.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(suffix, 0, result, prefix.length, suffix.length);
        return result;
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey) throws EncryptionException {
        return EncryptionUtils.decodeSecretKey(encodedSecretKey, "AES");
    }

    public static SecretKey decodeSecretKey(String encodedSecretKey, String algo) throws EncryptionException {
        byte[] secretKeyBytes = EncryptionUtils.decodeSequence(encodedSecretKey);
        return EncryptionUtils.recreateSecretKey(secretKeyBytes, algo);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, PrivateKey privateKey) throws EncryptionException {
        SecretKeyProperties props = new SecretKeyProperties();
        props.setCompressionSupported(false);
        return EncryptionUtils.decryptSecretKey(encodedEncryptedSecretKey, props, privateKey);
    }

    public static SecretKey decryptSecretKey(String encodedEncryptedSecretKey, SecretKeyProperties props, PrivateKey privateKey) throws EncryptionException {
        byte[] encryptedBytes = EncryptionUtils.decodeSequence(encodedEncryptedSecretKey);
        byte[] descryptedBytes = EncryptionUtils.decryptBytes(encryptedBytes, privateKey, props);
        return EncryptionUtils.recreateSecretKey(descryptedBytes, props.getKeyAlgo());
    }

    public static SecretKey recreateSecretKey(byte[] bytes, String algo) {
        return new SecretKeySpec(bytes, algo);
    }

    public static byte[] decodeSequence(String encodedSequence) throws EncryptionException {
        try {
            return Base64UrlUtility.decode(encodedSequence);
        }
        catch (Exception ex) {
            throw new EncryptionException(ex);
        }
    }
}

