/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.authorization;

import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.saml.assertion.Claims;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.authorization.JAXRSSAMLSecurityContext;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SubjectPrincipal;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.w3c.dom.Element;

public class SecurityContextProviderImpl
implements SecurityContextProvider {
    private static final String ROLE_QUALIFIER_PROPERTY = "org.apache.cxf.saml.claims.role.qualifier";
    private static final String ROLE_NAMEFORMAT_PROPERTY = "org.apache.cxf.saml.claims.role.nameformat";

    @Override
    public SecurityContext getSecurityContext(Message message, SamlAssertionWrapper wrapper) {
        Claims claims = this.getClaims(wrapper);
        Subject subject = this.getSubject(message, wrapper, claims);
        SecurityContext securityContext = this.doGetSecurityContext(message, subject, claims);
        if (securityContext instanceof SAMLSecurityContext) {
            Element assertionElement = wrapper.getElement();
            ((SAMLSecurityContext)securityContext).setAssertionElement(assertionElement);
        }
        return securityContext;
    }

    protected Claims getClaims(SamlAssertionWrapper wrapper) {
        return SAMLUtils.getClaims(wrapper);
    }

    protected Subject getSubject(Message message, SamlAssertionWrapper wrapper, Claims claims) {
        return SAMLUtils.getSubject(message, wrapper);
    }

    protected SecurityContext doGetSecurityContext(Message message, Subject subject, Claims claims) {
        String defaultRoleName = (String)message.getContextualProperty(ROLE_QUALIFIER_PROPERTY);
        String defaultNameFormat = (String)message.getContextualProperty(ROLE_NAMEFORMAT_PROPERTY);
        String subjectPrincipalName = this.getSubjectPrincipalName(subject, claims);
        SubjectPrincipal subjectPrincipal = new SubjectPrincipal(subjectPrincipalName, subject);
        JAXRSSAMLSecurityContext sc = new JAXRSSAMLSecurityContext(subjectPrincipal, claims, defaultRoleName == null ? "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role" : defaultRoleName, defaultNameFormat == null ? "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified" : defaultNameFormat);
        return sc;
    }

    protected String getSubjectPrincipalName(Subject subject, Claims claims) {
        return subject.getName();
    }
}

