/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.misc.processor.AbstractWSDLToProcessor;
import org.apache.cxf.tools.misc.processor.address.Address;
import org.apache.cxf.tools.misc.processor.address.AddressFactory;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;

public class WSDLToServiceProcessor
extends AbstractWSDLToProcessor {
    private static final String NEW_FILE_NAME_MODIFIER = "-service";
    private Map<QName, Service> services;
    private Service service;
    private Map<String, Port> ports;
    private Port port;
    private Binding binding;

    @Override
    public void process() throws ToolException {
        this.init();
        if (this.isServicePortExisted()) {
            Message msg = new Message("SERVICE_PORT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if (!this.isBindingExisted()) {
            Message msg = new Message("BINDING_NOT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        this.doAppendService();
    }

    private boolean isServicePortExisted() {
        return this.isServiceExisted() && this.isPortExisted();
    }

    private boolean isServiceExisted() {
        this.services = CastUtils.cast(this.wsdlDefinition.getServices());
        if (this.services == null) {
            return false;
        }
        for (QName serviceQName : this.services.keySet()) {
            String serviceName = serviceQName.getLocalPart();
            if (!serviceName.equals(this.env.get("service"))) continue;
            this.service = this.services.get(serviceQName);
            break;
        }
        return this.service != null;
    }

    private boolean isPortExisted() {
        this.ports = CastUtils.cast(this.service.getPorts());
        if (this.ports == null) {
            return false;
        }
        for (String portName : this.ports.keySet()) {
            if (!portName.equals(this.env.get("port"))) continue;
            this.port = this.ports.get(portName);
            break;
        }
        return this.port != null;
    }

    private boolean isBindingExisted() {
        Map bindings = CastUtils.cast(this.wsdlDefinition.getBindings());
        if (bindings == null) {
            return false;
        }
        for (QName bindingQName : bindings.keySet()) {
            String bindingName = bindingQName.getLocalPart();
            String attrBinding = (String)this.env.get("attrbinding");
            if (!attrBinding.equals(bindingName)) continue;
            this.binding = (Binding)bindings.get(bindingQName);
        }
        return this.binding != null;
    }

    @Override
    protected void init() throws ToolException {
        this.parseWSDL((String)this.env.get("wsdlurl"));
    }

    private void doAppendService() throws ToolException {
        if (this.service == null) {
            this.service = this.wsdlDefinition.createService();
            this.service.setQName(new QName("wsdl", (String)this.env.get("service")));
        }
        if (this.port == null) {
            this.port = this.wsdlDefinition.createPort();
            this.port.setName((String)this.env.get("port"));
            this.port.setBinding(this.binding);
        }
        this.setAddrElement();
        this.service.addPort(this.port);
        this.wsdlDefinition.addService(this.service);
        WSDLWriter wsdlWriter = this.wsdlFactory.newWSDLWriter();
        Writer outputWriter = this.getOutputWriter(NEW_FILE_NAME_MODIFIER);
        try {
            wsdlWriter.writeWSDL(this.wsdlDefinition, outputWriter);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_WRITE_WSDL", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
        try {
            outputWriter.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_CLOSE_WSDL_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)ioe);
        }
    }

    private void setAddrElement() throws ToolException {
        String transport = (String)this.env.get("transport");
        Address address = AddressFactory.getInstance().getAddresser(transport);
        Map<String, String> ns = address.getNamespaces(this.env);
        for (String key : ns.keySet()) {
            this.wsdlDefinition.addNamespace(key, ns.get(key));
        }
        WSDLExtensibilityPlugin plugin = this.getWSDLPlugin(transport, Port.class);
        try {
            ExtensibilityElement extElement = plugin.createExtension(address.buildAddressArguments(this.env));
            this.port.addExtensibilityElement(extElement);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAP_ADDRESS", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)wse);
        }
    }
}

