/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.util.ClassCollector;

public final class XmlSeeAlsoAnnotator
implements Annotator {
    private ClassCollector collector;

    public XmlSeeAlsoAnnotator(ClassCollector c) {
        this.collector = c;
    }

    @Override
    public void annotate(JavaAnnotatable ja) {
        if (this.collector == null || this.collector.getTypesPackages().isEmpty()) {
            return;
        }
        JavaInterface intf = null;
        if (!(ja instanceof JavaInterface)) {
            throw new RuntimeException("XmlSeeAlso can only annotate JavaInterface");
        }
        intf = (JavaInterface)ja;
        JAnnotation jaxbAnnotation = new JAnnotation(XmlSeeAlso.class);
        intf.addImports(jaxbAnnotation.getImports());
        ArrayList<JavaType> types = new ArrayList<JavaType>();
        for (String pkg : this.collector.getTypesPackages()) {
            if (pkg.equals(intf.getPackageName())) {
                types.add(new JavaType(null, "ObjectFactory", null));
                continue;
            }
            types.add(new JavaType(null, pkg + ".ObjectFactory", null));
        }
        jaxbAnnotation.addElement(new JAnnotationElement(null, types));
        intf.addAnnotation(jaxbAnnotation);
    }
}

