/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper;

import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.ws.Holder;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.XmlJavaTypeAdapterAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.XmlListAnotator;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.constants.Constants;

public final class ParameterMapper {
    private ParameterMapper() {
    }

    public static JavaParameter map(JavaMethod jm, MessagePartInfo part, JavaType.Style style, ToolContext context) {
        XmlSchemaElement element;
        String name = ProcessorUtil.mangleNameToVariableName(part.getName().getLocalPart());
        String namespace = ProcessorUtil.resolvePartNamespace(part);
        String type = ProcessorUtil.resolvePartType(part, context);
        JavaParameter parameter = new JavaParameter(name, type, namespace);
        parameter.setPartName(part.getName().getLocalPart());
        if (part.getXmlSchema() instanceof XmlSchemaSimpleType) {
            ParameterMapper.processXmlSchemaSimpleType((XmlSchemaSimpleType)part.getXmlSchema(), jm, parameter, part);
        } else if (part.getXmlSchema() instanceof XmlSchemaElement && (element = (XmlSchemaElement)part.getXmlSchema()).getSchemaType() instanceof XmlSchemaSimpleType) {
            ParameterMapper.processXmlSchemaSimpleType((XmlSchemaSimpleType)element.getSchemaType(), jm, parameter, part);
        }
        parameter.setQName(ProcessorUtil.getElementName(part));
        parameter.setDefaultValueWriter(ProcessorUtil.getDefaultValueWriter(part, context));
        String fullJavaName = ProcessorUtil.getFullClzName(part, context, false);
        parameter.setClassName(fullJavaName);
        if (style == JavaType.Style.INOUT || style == JavaType.Style.OUT) {
            parameter.setHolder(true);
            parameter.setHolderName(Holder.class.getName());
            String holderClass = fullJavaName;
            if (JAXBUtils.holderClass(fullJavaName) != null) {
                holderClass = JAXBUtils.holderClass(fullJavaName).getName();
            }
            parameter.setClassName(holderClass);
        }
        parameter.setStyle(style);
        return parameter;
    }

    private static void processXmlSchemaSimpleType(XmlSchemaSimpleType xmlSchema, JavaMethod jm, JavaParameter parameter, MessagePartInfo part) {
        if (!(!(xmlSchema.getContent() instanceof XmlSchemaSimpleTypeList) || part.isElement() && jm.isWrapperStyle())) {
            parameter.annotate(new XmlListAnotator(jm.getInterface()));
        }
        if (!(!Constants.XSD_HEXBIN.equals(xmlSchema.getQName()) || part.isElement() && jm.isWrapperStyle())) {
            parameter.annotate(new XmlJavaTypeAdapterAnnotator(jm.getInterface(), HexBinaryAdapter.class));
        }
    }
}

