/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https_jetty;

import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;

public class CXFJettySslSocketConnector
extends SslSelectChannelConnector {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFJettySslSocketConnector.class);
    protected KeyManager[] keyManagers;
    protected TrustManager[] trustManagers;
    protected SecureRandom secureRandom;
    protected List<String> cipherSuites;
    protected FiltersType cipherSuitesFilter;

    protected void setCipherSuites(List<String> cs) {
        this.cipherSuites = cs;
    }

    protected void setCipherSuitesFilter(FiltersType filter) {
        this.cipherSuitesFilter = filter;
    }

    protected void setKeyManagers(KeyManager[] kmgrs) {
        this.keyManagers = kmgrs;
    }

    protected void setTrustManagers(TrustManager[] tmgrs) {
        this.trustManagers = tmgrs;
    }

    protected void setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
    }

    protected void setClientAuthentication(ClientAuthentication clientAuth) {
        this.getCxfSslContextFactory().setWantClientAuth(true);
        if (clientAuth != null) {
            if (clientAuth.isSetWant()) {
                this.getCxfSslContextFactory().setWantClientAuth(clientAuth.isWant());
            }
            if (clientAuth.isSetRequired()) {
                this.getCxfSslContextFactory().setNeedClientAuth(clientAuth.isRequired());
            }
        }
    }

    protected void doStart() throws Exception {
        this.getCxfSslContextFactory().setSslContext(this.createSSLContext());
        super.doStart();
    }

    protected SSLContext createSSLContext() throws Exception {
        SSLContext context;
        String proto = this.getCxfSslContextFactory().getProtocol() == null ? "TLS" : this.getCxfSslContextFactory().getProtocol();
        SSLContext sSLContext = context = this.getCxfSslContextFactory().getProvider() == null ? SSLContext.getInstance(proto) : SSLContext.getInstance(proto, this.getCxfSslContextFactory().getProvider());
        if (this.getCxfSslContextFactory().getCertAlias() != null) {
            this.getKeyManagersWithCertAlias();
        }
        context.init(this.keyManagers, this.trustManagers, this.secureRandom);
        String[] cs = SSLUtils.getCiphersuites(this.cipherSuites, SSLUtils.getServerSupportedCipherSuites(context), this.cipherSuitesFilter, LOG, true);
        this.getCxfSslContextFactory().setExcludeCipherSuites(cs);
        return context;
    }

    protected void getKeyManagersWithCertAlias() throws Exception {
        if (this.getCxfSslContextFactory().getCertAlias() != null) {
            for (int idx = 0; idx < this.keyManagers.length; ++idx) {
                if (!(this.keyManagers[idx] instanceof X509KeyManager)) continue;
                this.keyManagers[idx] = new AliasedX509ExtendedKeyManager(this.getCxfSslContextFactory().getCertAlias(), (X509KeyManager)this.keyManagers[idx]);
            }
        }
    }

    public CxfSslContextFactory getCxfSslContextFactory() {
        try {
            Object o = ((Object)((Object)this)).getClass().getMethod("getSslContextFactory", new Class[0]).invoke((Object)this, new Object[0]);
            return ReflectionInvokationHandler.createProxyWrapper(o, CxfSslContextFactory.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static interface CxfSslContextFactory {
        public void setExcludeCipherSuites(String ... var1);

        public String getProtocol();

        public String getProvider();

        public void setSslContext(SSLContext var1);

        public void setNeedClientAuth(boolean var1);

        public void setWantClientAuth(boolean var1);

        public void setProtocol(String var1);

        public void setProvider(String var1);

        public void setCertAlias(String var1);

        public String getCertAlias();
    }
}

