/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.transport.jms.uri.JMSURIParser;

public class JMSEndpoint {
    public static final String JNDI = "jndi";
    public static final String TOPIC = "topic";
    public static final String QUEUE = "queue";
    public static final String JNDI_TOPIC = "jndi-topic";
    public static final String DELIVERYMODE_PARAMETER_NAME = "deliveryMode";
    public static final String TIMETOLIVE_PARAMETER_NAME = "timeToLive";
    public static final String PRIORITY_PARAMETER_NAME = "priority";
    public static final String REPLYTONAME_PARAMETER_NAME = "replyToName";
    public static final String MESSAGE_TYPE_PARAMETER_NAME = "messageType";
    public static final DeliveryModeType DELIVERYMODE_DEFAULT = DeliveryModeType.PERSISTENT;
    public static final long TIMETOLIVE_DEFAULT = 0L;
    public static final int PRIORITY_DEFAULT = 4;
    public static final String JNDICONNECTIONFACTORYNAME_PARAMETER_NAME = "jndiConnectionFactoryName";
    public static final String JNDIINITIALCONTEXTFACTORY_PARAMETER_NAME = "jndiInitialContextFactory";
    public static final String JNDIURL_PARAMETER_NAME = "jndiURL";
    public static final String JNDI_PARAMETER_NAME_PREFIX = "jndi-";
    public static final String TOPICREPLYTONAME_PARAMETER_NAME = "topicReplyToName";
    Map<String, String> jndiParameters = new HashMap<String, String>();
    Map<String, String> parameters = new HashMap<String, String>();
    private String endpointUri;
    private String jmsVariant = "queue";
    private String destinationName;
    private DeliveryModeType deliveryMode;
    private MessageType messageType;
    private long timeToLive;
    private Integer priority;
    private String replyToName;
    private String topicReplyToName;
    private String jndiConnectionFactoryName;
    private String jndiInitialContextFactory;
    private String jndiURL;
    private String username;
    private String password;
    private boolean reconnectOnException = true;

    public JMSEndpoint(String endpointUri) {
        this();
        if (!StringUtils.isEmpty(endpointUri) && !"jms://".equals(endpointUri) && endpointUri.startsWith("jms")) {
            this.endpointUri = endpointUri;
            JMSURIParser parsed = new JMSURIParser(endpointUri);
            this.setJmsVariant(parsed.getVariant());
            this.destinationName = parsed.getDestination();
            JMSEndpoint.configureProperties(this, parsed.parseQuery());
        }
    }

    public JMSEndpoint() {
    }

    private static void configureProperties(JMSEndpoint endpoint, Map<String, String> params) {
        String deliveryMode = JMSEndpoint.getAndRemoveParameter(params, DELIVERYMODE_PARAMETER_NAME);
        String timeToLive = JMSEndpoint.getAndRemoveParameter(params, TIMETOLIVE_PARAMETER_NAME);
        String priority = JMSEndpoint.getAndRemoveParameter(params, PRIORITY_PARAMETER_NAME);
        String replyToName = JMSEndpoint.getAndRemoveParameter(params, REPLYTONAME_PARAMETER_NAME);
        String topicReplyToName = JMSEndpoint.getAndRemoveParameter(params, TOPICREPLYTONAME_PARAMETER_NAME);
        String jndiConnectionFactoryName = JMSEndpoint.getAndRemoveParameter(params, JNDICONNECTIONFACTORYNAME_PARAMETER_NAME);
        String jndiInitialContextFactory = JMSEndpoint.getAndRemoveParameter(params, JNDIINITIALCONTEXTFACTORY_PARAMETER_NAME);
        String jndiUrl = JMSEndpoint.getAndRemoveParameter(params, JNDIURL_PARAMETER_NAME);
        String messageType = JMSEndpoint.getAndRemoveParameter(params, MESSAGE_TYPE_PARAMETER_NAME);
        if (deliveryMode != null) {
            endpoint.setDeliveryMode(DeliveryModeType.valueOf(deliveryMode));
        }
        if (timeToLive != null) {
            endpoint.setTimeToLive(Long.valueOf(timeToLive));
        }
        if (priority != null) {
            endpoint.setPriority(Integer.valueOf(priority));
        }
        if (replyToName != null && topicReplyToName != null) {
            throw new IllegalArgumentException("The replyToName and topicReplyToName should not be defined at the same time.");
        }
        if (replyToName != null) {
            endpoint.setReplyToName(replyToName);
        }
        if (topicReplyToName != null) {
            endpoint.setTopicReplyToName(topicReplyToName);
        }
        if (jndiConnectionFactoryName != null) {
            endpoint.setJndiConnectionFactoryName(jndiConnectionFactoryName);
        }
        if (jndiInitialContextFactory != null) {
            endpoint.setJndiInitialContextFactory(jndiInitialContextFactory);
        }
        if (jndiUrl != null) {
            endpoint.setJndiURL(jndiUrl);
        }
        if (messageType != null) {
            endpoint.setMessageType(MessageType.fromValue(messageType));
        }
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null || value.equals("")) continue;
            if (key.startsWith(JNDI_PARAMETER_NAME_PREFIX)) {
                key = key.substring(5);
                endpoint.putJndiParameter(key, value);
                continue;
            }
            endpoint.putParameter(key, value);
        }
    }

    private static String getAndRemoveParameter(Map<String, String> parameters, String parameterName) {
        String value = parameters.get(parameterName);
        parameters.remove(parameterName);
        return value;
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder("jms:");
        if (this.jmsVariant == JNDI_TOPIC) {
            requestUri.append(JNDI);
        } else {
            requestUri.append(this.jmsVariant);
        }
        requestUri.append(":" + this.destinationName);
        boolean first = true;
        for (String key : this.parameters.keySet()) {
            if ("targetService".equals(key) || MESSAGE_TYPE_PARAMETER_NAME.equals(key)) continue;
            String value = this.parameters.get(key);
            if (first) {
                requestUri.append("?" + key + "=" + value);
                first = false;
                continue;
            }
            requestUri.append("&" + key + "=" + value);
        }
        return requestUri.toString();
    }

    public void putJndiParameter(String key, String value) {
        this.jndiParameters.put(key, value);
    }

    public void putParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, String> getJndiParameters() {
        return this.jndiParameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public String getJmsVariant() {
        return this.jmsVariant;
    }

    public void setJmsVariant(String jmsVariant) {
        if (jmsVariant == null) {
            this.jmsVariant = QUEUE;
        }
        if (!(QUEUE.equals(jmsVariant) || TOPIC.equals(jmsVariant) || JNDI.equals(jmsVariant) || JNDI_TOPIC.equals(jmsVariant))) {
            throw new IllegalArgumentException("Unknow JMS Variant " + jmsVariant);
        }
        this.jmsVariant = jmsVariant;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isSetDeliveryMode() {
        return this.deliveryMode != null;
    }

    public DeliveryModeType getDeliveryMode() {
        return this.deliveryMode == null ? DeliveryModeType.PERSISTENT : this.deliveryMode;
    }

    public void setDeliveryMode(DeliveryModeType deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public MessageType getMessageType() {
        return this.messageType == null ? MessageType.BYTE : this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public boolean isSetPriority() {
        return this.priority != null;
    }

    public int getPriority() {
        return this.priority == null ? 4 : this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getReplyToName() {
        return this.replyToName;
    }

    public void setReplyToName(String replyToName) {
        this.replyToName = replyToName;
    }

    public String getTopicReplyToName() {
        return this.topicReplyToName;
    }

    public void setTopicReplyToName(String topicReplyToName) {
        this.topicReplyToName = topicReplyToName;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this.jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
    }

    public String getJndiURL() {
        return this.jndiURL;
    }

    public void setJndiURL(String jndiURL) {
        this.jndiURL = jndiURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    public static enum MessageType {
        BYTE("byte"),
        BINARY("binary"),
        TEXT("text");

        private final String value;

        private MessageType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static MessageType fromValue(String v) {
            for (MessageType c : MessageType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum DeliveryModeType {
        PERSISTENT,
        NON_PERSISTENT;

    }
}

