/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.policy.PolicyVerificationOutInterceptor;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;
import org.apache.cxf.ws.rm.RewindableInputStream;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;
import org.apache.cxf.ws.security.SecurityConstants;

public class RMCaptureOutInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMCaptureOutInterceptor.class);

    public RMCaptureOutInterceptor() {
        super("pre-stream");
        this.addBefore(AttachmentOutInterceptor.class.getName());
        this.addBefore(LoggingOutInterceptor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Message msg) throws SequenceFault, RMException {
        SourceSequence ss;
        Collection<SequenceAcknowledgement> acks;
        AddressingProperties maps = ContextUtils.retrieveMAPs(msg, false, true, false);
        if (null == maps) {
            LogUtils.log(LOG, Level.WARNING, "MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        if (Boolean.TRUE.equals(msg.get("org.apache.cxf.ws.rm.retransmitting"))) {
            return;
        }
        if (this.isRuntimeFault(msg)) {
            LogUtils.log(LOG, Level.WARNING, "RUNTIME_FAULT_MSG");
            Throwable cause = msg.getContent(Exception.class).getCause();
            if (cause instanceof SequenceFault || cause instanceof RMException) {
                maps.getAction().setValue(this.getAddressingNamespace(maps) + "/fault");
            }
            return;
        }
        Source source = this.getManager().getSource(msg);
        RMConfiguration config = this.getManager().getEffectiveConfiguration(msg);
        String wsaNamespace = config.getAddressingNamespace();
        String rmNamespace = config.getRMNamespace();
        ProtocolVariation protocol = ProtocolVariation.findVariant(rmNamespace, wsaNamespace);
        RMContextUtils.setProtocolVariation(msg, protocol);
        maps.exposeAs(wsaNamespace);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse(msg);
        RMConstants constants = protocol.getConstants();
        boolean isLastMessage = constants.getCloseSequenceAction().equals(action);
        RMProperties rmpsOut = RMContextUtils.retrieveRMProperties(msg, true);
        if (null == rmpsOut) {
            rmpsOut = new RMProperties();
            rmpsOut.exposeAs(protocol.getWSRMNamespace());
            RMContextUtils.storeRMProperties(msg, rmpsOut, true);
        }
        if (msg.getExchange().isOneWay()) {
            msg.getExchange().put("org.apache.cxf.transport.processOneWayResponse", true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        long inMessageNumber = 0L;
        if (isApplicationMessage) {
            rmpsIn = RMContextUtils.retrieveRMProperties(msg, false);
            if (null != rmpsIn && null != rmpsIn.getSequence()) {
                inSeqId = rmpsIn.getSequence().getIdentifier();
                inMessageNumber = rmpsIn.getSequence().getMessageNumber();
            }
            ContextUtils.storeDeferUncorrelatedMessageAbort(msg);
        }
        Map invocationContext = (Map)msg.get("org.apache.cxf.invocation.context");
        if ((isApplicationMessage || isLastMessage && invocationContext != null) && !isPartialResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            Source source2 = source;
            synchronized (source2) {
                SourceSequence seq = null;
                seq = isLastMessage ? (SourceSequence)invocationContext.get(SourceSequence.class.getName()) : this.getManager().getSequence(inSeqId, msg, maps);
                assert (null != seq);
                seq.nextMessageNumber(inSeqId, inMessageNumber, isLastMessage);
                if (Boolean.TRUE.equals(msg.getContextualProperty("org.apache.cxf.ws.rm.last-message"))) {
                    seq.setLastMessage(true);
                }
                rmpsOut.setSequence(seq);
                if (seq.isLastMessage()) {
                    source.setCurrent(null);
                }
            }
        } else if (!MessageUtils.isRequestor(msg) && constants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(constants.getCreateSequenceResponseAction());
        } else if (isPartialResponse && action == null && this.isResponseToAction(msg, constants.getSequenceAckAction()) && (acks = rmpsIn.getAcks()).size() == 1 && (ss = source.getSequence(acks.iterator().next().getIdentifier())) != null && ss.allAcknowledged()) {
            RMCaptureOutInterceptor.setAction(maps, constants.getTerminateSequenceAction());
            this.setTerminateSequence(msg, ss.getIdentifier(), protocol);
            msg.remove("org.apache.cxf.partial.response.empty");
            source.removeSequence(ss);
        }
        if (isApplicationMessage && !isPartialResponse) {
            this.getManager().initializeInterceptorChain(msg);
            this.captureMessage(msg);
        }
    }

    private void captureMessage(Message message) {
        MessageImpl capture = new MessageImpl();
        capture.setId(message.getId());
        capture.put("org.apache.cxf.rm.captureOnly", Boolean.TRUE);
        for (Class<?> clas : message.getContentFormats()) {
            if (OutputStream.class == clas) continue;
            Object content = message.getContent(clas);
            if (content instanceof MessageContentsList) {
                content = new MessageContentsList((MessageContentsList)content);
            }
            capture.setContent(clas, content);
        }
        for (String key : message.keySet()) {
            capture.put(key, message.get(key));
        }
        for (String key : message.getContextualPropertyKeys()) {
            capture.setContextualProperty(key, message.getContextualProperty(key));
        }
        if (message instanceof SoapMessage) {
            capture = new SoapMessage(capture);
            ((SoapMessage)capture).setVersion(((SoapMessage)message).getVersion());
        }
        PhaseInterceptorChain chain = (PhaseInterceptorChain)message.getInterceptorChain();
        PhaseInterceptorChain cchain = chain.cloneChain();
        ListIterator<Interceptor<? extends Message>> iterator = cchain.getIterator();
        boolean past = false;
        boolean ending = false;
        while (iterator.hasNext()) {
            PhaseInterceptor intercept = (PhaseInterceptor)iterator.next();
            String id = intercept.getId();
            if (RMCaptureOutInterceptor.class.getName().equals(id)) {
                past = true;
                continue;
            }
            if (!past || id == null) continue;
            if (id.startsWith(RMCaptureOutInterceptor.class.getPackage().getName()) && !id.equals(RetransmissionInterceptor.class.getName()) || id.startsWith(SecurityConstants.class.getPackage().getName()) || PolicyVerificationOutInterceptor.class.getName().equals(id) || AttachmentOutInterceptor.class.getName().equals(id) || LoggingOutInterceptor.class.getName().equals(id) || "org.apache.cxf.systest.ws.rm.MessageLossSimulator$MessageLossEndingInterceptor".equals(id)) {
                cchain.remove(intercept);
                continue;
            }
            if (!MessageSenderInterceptor.MessageSenderEndingInterceptor.class.getName().equals(id)) continue;
            ending = true;
        }
        if (!ending) {
            cchain.add(new MessageSenderInterceptor.MessageSenderEndingInterceptor());
        }
        capture.setInterceptorChain(cchain);
        LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
        capture.setContent(OutputStream.class, bos);
        ExchangeImpl captureExchange = new ExchangeImpl((ExchangeImpl)message.getExchange());
        capture.setExchange(captureExchange);
        captureExchange.setOutMessage(capture);
        captureExchange.setConduit(new AbstractConduit(captureExchange.getConduit(capture).getTarget()){

            @Override
            public void prepare(Message message) throws IOException {
            }

            @Override
            protected Logger getLogger() {
                return null;
            }
        });
        cchain.doInterceptStartingAfter(capture, RMCaptureOutInterceptor.class.getName());
        try {
            RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
            SequenceType sequence = rmps.getSequence();
            Long number = sequence.getMessageNumber();
            Identifier sid = sequence.getIdentifier();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Captured message " + number + " in sequence " + sid.getValue());
            }
            ByteArrayInputStream bis = bos.createInputStream();
            message.put("org.apache.cxf.ws.rm.content", RewindableInputStream.makeRewindable(bis));
            RMManager manager = this.getManager();
            manager.getRetransmissionQueue().start();
            manager.getRetransmissionQueue().addUnacknowledged(message);
            RMStore store = manager.getStore();
            if (null != store) {
                AddressingProperties maps;
                Source s = manager.getSource(message);
                SourceSequence ss = s.getSequence(sid);
                RMMessage msg = new RMMessage();
                msg.setMessageNumber(number);
                if (!MessageUtils.isRequestor(message) && null != (maps = RMContextUtils.retrieveMAPs(message, false, true)) && null != maps.getTo()) {
                    msg.setTo(maps.getTo().getValue());
                }
                msg.setContent(bis);
                store.persistOutgoing(ss, msg);
            }
        }
        catch (RMException e) {
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error persisting message", e);
        }
    }

    private String getAddressingNamespace(AddressingProperties maps) {
        String wsaNamespace = maps.getNamespaceURI();
        if (wsaNamespace == null) {
            this.getManager().getConfiguration().getAddressingNamespace();
        }
        return wsaNamespace;
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode(message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }

    private boolean isResponseToAction(Message msg, String action) {
        AddressingProperties inMaps = RMContextUtils.retrieveMAPs(msg, false, false);
        String inAction = null;
        if (null != inMaps.getAction()) {
            inAction = inMaps.getAction().getValue();
        }
        return action.equals(inAction);
    }

    private void setTerminateSequence(Message msg, Identifier identifier, ProtocolVariation protocol) throws RMException {
        TerminateSequenceType ts = new TerminateSequenceType();
        ts.setIdentifier(identifier);
        MessageContentsList contents = new MessageContentsList(protocol.getCodec().convertToSend(ts));
        msg.setContent(List.class, contents);
        ExchangeImpl newex = new ExchangeImpl();
        Exchange oldex = msg.getExchange();
        newex.put(Bus.class, oldex.getBus());
        newex.put(Endpoint.class, oldex.getEndpoint());
        newex.put(Service.class, oldex.getEndpoint().getService());
        newex.put(Binding.class, oldex.getEndpoint().getBinding());
        newex.setConduit(oldex.getConduit(msg));
        newex.setDestination(oldex.getDestination());
        RMEndpoint rmep = this.getManager().getReliableEndpoint(msg);
        OperationInfo oi = rmep.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(protocol.getConstants().getTerminateSequenceAnonymousOperationName());
        BindingInfo bi = rmep.getBindingInfo(protocol);
        BindingOperationInfo boi = bi.getOperation(oi);
        newex.put(BindingInfo.class, bi);
        newex.put(BindingOperationInfo.class, boi);
        newex.put(OperationInfo.class, boi.getOperationInfo());
        msg.setExchange(newex);
        newex.setOutMessage(msg);
    }

    private static void setAction(AddressingProperties maps, String action) {
        AttributedURIType actionURI = new AttributedURIType();
        actionURI.setValue(action);
        maps.setAction(actionURI);
    }
}

