/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.stax.securityEvent.OperationSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class PolicyStaxActionInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyStaxActionInInterceptor.class);

    public PolicyStaxActionInInterceptor() {
        super("pre-protocol");
        this.getBefore().add(StaxSecurityContextInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        OperationSecurityEvent securityEvent;
        AssertionInfoMap aim = soapMessage.get(AssertionInfoMap.class);
        List incomingSecurityEventList = (List)soapMessage.get(SecurityEvent.class.getName() + ".in");
        if (aim == null || incomingSecurityEventList == null) {
            return;
        }
        if (MessageUtils.isRequestor(soapMessage) && this.isEventInResults(WSSecurityEventConstants.NoSecurity, incomingSecurityEventList) && (securityEvent = (OperationSecurityEvent)this.findEvent(WSSecurityEventConstants.Operation, incomingSecurityEventList)) != null && soapMessage.getVersion().getFault().equals(securityEvent.getOperation())) {
            LOG.warning("Request does not contain Security header, but it's a fault.");
            return;
        }
        this.assertAllSecurityAssertions(aim);
        this.assertAllAlgorithmSuites("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", aim);
        this.assertAllAlgorithmSuites("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", aim);
    }

    private boolean isEventInResults(SecurityEventConstants.Event event, List<SecurityEvent> incomingSecurityEventList) {
        for (SecurityEvent incomingEvent : incomingSecurityEventList) {
            if (event != incomingEvent.getSecurityEventType()) continue;
            return true;
        }
        return false;
    }

    private SecurityEvent findEvent(SecurityEventConstants.Event event, List<SecurityEvent> incomingSecurityEventList) {
        for (SecurityEvent incomingEvent : incomingSecurityEventList) {
            if (event != incomingEvent.getSecurityEventType()) continue;
            return incomingEvent;
        }
        return null;
    }

    private void assertAllSecurityAssertions(AssertionInfoMap aim) {
        for (QName key : aim.keySet()) {
            Collection ais;
            if (!"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(key.getNamespaceURI()) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702".equals(key.getNamespaceURI()) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200802".equals(key.getNamespaceURI()) || (ais = (Collection)aim.get(key)) == null || ais.isEmpty()) continue;
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    private void assertAllAlgorithmSuites(String spNamespace, AssertionInfoMap aim) {
        Collection sp11Ais = (Collection)aim.get(new QName(spNamespace, "AlgorithmSuite"));
        if (sp11Ais != null) {
            for (AssertionInfo ai : sp11Ais) {
                Collection algAis;
                ai.setAsserted(true);
                AlgorithmSuite algorithmSuite = (AlgorithmSuite)ai.getAssertion();
                AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmSuite.getAlgorithmSuiteType();
                String namespace = algorithmSuiteType.getNamespace();
                if (namespace == null) {
                    namespace = spNamespace;
                }
                if ((algAis = (Collection)aim.get(new QName(namespace, algorithmSuiteType.getName()))) == null) continue;
                for (AssertionInfo algAi : algAis) {
                    algAi.setAsserted(true);
                }
            }
        }
    }
}

